"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "selectFacilityIds", {
    enumerable: true,
    get: function() {
        return selectFacilityIds;
    }
});
const selectFacilityIds = (config)=>{
    const { serverFacilityId, serverFacilityIds } = config;
    if (serverFacilityId && serverFacilityIds) {
        throw new Error('Both serverFacilityId and serverFacilityIds are set in config, a facility server should either have a single facility or multiple facilities, not both.');
    }
    return serverFacilityId ? [
        serverFacilityId
    ] : serverFacilityIds;
};

//# sourceMappingURL=configSelectors.js.map