"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceRecordPrintout", {
    enumerable: true,
    get: function() {
        return InvoiceRecordPrintout;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _lodash = require("lodash");
const _constants = require("@tamanu/constants");
const _Layout = require("./Layout");
const _LetterheadSection = require("./LetterheadSection");
const _MultiPageHeader = require("./printComponents/MultiPageHeader");
const _patientAccessors = require("../patientAccessors");
const _Footer = require("./printComponents/Footer");
const _dateTime = require("../dateTime");
const _EncounterDetails = require("./printComponents/EncounterDetails");
const _InvoiceDetails = require("./printComponents/InvoiceDetails");
const _invoice = require("../invoice");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
const _PatientDetails = require("./printComponents/PatientDetails");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const borderStyle = '1 solid black';
const pageStyles = _renderer.StyleSheet.create({
    body: {
        paddingHorizontal: 50,
        paddingTop: 30,
        paddingBottom: 50
    }
});
const textStyles = _renderer.StyleSheet.create({
    sectionTitle: {
        fontFamily: 'Helvetica-Bold',
        marginBottom: 3,
        fontSize: 11,
        fontWeight: 600
    }
});
const tableStyles = _renderer.StyleSheet.create({
    table: {
        flexDirection: 'column',
        marginBottom: 5
    },
    row: {
        flexDirection: 'row',
        justifyContent: 'space-evenly',
        borderTop: borderStyle,
        borderRight: borderStyle,
        borderBottom: borderStyle,
        marginBottom: -1
    },
    baseCell: {
        flexDirection: 'row',
        borderLeft: borderStyle,
        alignItems: 'flex-start',
        padding: 7
    },
    p: {
        fontFamily: 'Helvetica',
        fontSize: 9
    },
    noteText: {
        fontFamily: 'Helvetica',
        fontSize: 7,
        marginTop: 1
    }
});
const priceCellStyles = _renderer.StyleSheet.create({
    container: {
        justifyContent: 'space-between',
        width: '100%',
        flexDirection: 'row'
    },
    crossOutText: {
        textDecoration: 'line-through'
    }
});
const summaryPaneStyles = _renderer.StyleSheet.create({
    container: {
        width: 220,
        marginLeft: 'auto',
        paddingHorizontal: 7,
        paddingVertical: 3,
        border: borderStyle
    },
    item: {
        flexDirection: 'row',
        justifyContent: 'space-between',
        marginTop: 4.5,
        marginBottom: 4.5
    },
    subItem: {
        width: 56,
        flexDirection: 'row',
        justifyContent: 'space-between'
    }
});
const HorizontalRule = ({ width = '1px' })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            borderBottom: `${width} solid black`
        }
    });
};
const Table = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: tableStyles.table,
        ...props
    });
const Row = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: tableStyles.row,
        ...props
    });
const P = ({ style = {}, children, isBold })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: [
            tableStyles.p,
            isBold && {
                fontFamily: 'Helvetica-Bold'
            },
            style
        ]
    }, children);
const Cell = ({ children, style = {} })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            tableStyles.baseCell,
            style
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, null, children));
const CustomCellComponent = ({ children, style = {} })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            tableStyles.baseCell,
            style
        ]
    }, children);
const getPrice = (item)=>{
    const price = (0, _invoice.getInvoiceItemPriceDisplay)(item);
    const discountPrice = (0, _invoice.getInvoiceItemDiscountPriceDisplay)(item);
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: priceCellStyles.container
    }, /*#__PURE__*/ _react.default.createElement(P, {
        style: discountPrice ? priceCellStyles.crossOutText : undefined
    }, price), !!discountPrice && /*#__PURE__*/ _react.default.createElement(P, null, discountPrice));
};
const getInvoiceItemDetails = (item)=>{
    const name = item.productName;
    const note = item.note;
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(P, null, name, !item.productDiscountable && ' (non-discountable)')), !!note && /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(P, {
        style: [
            tableStyles.noteText
        ]
    }, "Note: ", note)));
};
const HeaderCell = ({ children, style })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            tableStyles.baseCell,
            style
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, {
        style: {
            fontFamily: 'Helvetica-Bold'
        }
    }, children));
const SectionSpacing = ()=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            paddingBottom: '10px'
        }
    });
const getInsurerPaymentStatus = (insurerPayment)=>{
    if (insurerPayment?.status === _constants.INVOICE_INSURER_PAYMENT_STATUSES.REJECTED) {
        return /*#__PURE__*/ _react.default.createElement(P, null, `${(0, _lodash.capitalize)(insurerPayment?.status)}${insurerPayment?.reason ? ` (${insurerPayment?.reason})` : ''}`);
    }
    return (0, _lodash.capitalize)(insurerPayment?.status);
};
const COLUMNS = {
    invoiceItems: [
        {
            key: 'orderDate',
            title: 'Date',
            style: {
                width: '12%'
            },
            accessor: ({ orderDate })=>orderDate ? (0, _dateTime.formatShort)(orderDate) : '--/--/----'
        },
        {
            key: 'productName',
            title: 'Details',
            style: {
                width: '34%'
            },
            accessor: (row)=>getInvoiceItemDetails(row),
            CellComponent: CustomCellComponent
        },
        {
            key: 'productCode',
            title: 'Code',
            style: {
                width: '10%'
            },
            accessor: ({ productCode })=>productCode
        },
        {
            key: 'quantity',
            title: 'Quantity',
            style: {
                width: '11%'
            },
            accessor: ({ quantity })=>quantity
        },
        {
            key: 'orderedBy',
            title: 'Ordered by',
            accessor: ({ orderedByUser })=>orderedByUser?.displayName,
            style: {
                width: '14%'
            }
        },
        {
            key: 'price',
            title: 'Price',
            accessor: (row)=>getPrice(row),
            style: {
                width: '19%'
            },
            CellComponent: CustomCellComponent
        }
    ],
    patientPayments: [
        {
            key: 'date',
            title: 'Date',
            style: {
                width: '15%'
            },
            accessor: ({ date })=>date ? (0, _dateTime.formatShort)(date) : '--/--/----'
        },
        {
            key: 'methodName',
            title: 'Method',
            style: {
                width: '28%'
            },
            accessor: ({ patientPayment })=>patientPayment?.method?.name
        },
        {
            key: 'amount',
            title: 'Amount',
            style: {
                width: '15%'
            },
            accessor: ({ amount })=>(0, _invoice.formatDisplayPrice)(amount)
        },
        {
            key: 'receiptNumber',
            title: 'Receipt number',
            accessor: ({ receiptNumber })=>receiptNumber,
            style: {
                width: '21%'
            }
        },
        {
            key: 'remainingBalance',
            title: 'Remaining balance',
            accessor: ({ remainingBalance })=>remainingBalance,
            style: {
                width: '21%'
            }
        }
    ],
    insurerPayments: [
        {
            key: 'date',
            title: 'Date',
            style: {
                width: '15%'
            },
            accessor: ({ date })=>date ? (0, _dateTime.formatShort)(date) : '--/--/----'
        },
        {
            key: 'insurerName',
            title: 'Payer',
            style: {
                width: '17%'
            },
            accessor: ({ insurerPayment })=>insurerPayment?.insurer?.name
        },
        {
            key: 'amount',
            title: 'Amount',
            style: {
                width: '11%'
            },
            accessor: ({ amount })=>amount
        },
        {
            key: 'receiptNumber',
            title: 'Receipt number',
            accessor: ({ receiptNumber })=>receiptNumber,
            style: {
                width: '14%'
            }
        },
        {
            key: 'remainingBalance',
            title: 'Remaining balance',
            accessor: ({ remainingBalance })=>remainingBalance,
            style: {
                width: '13%'
            }
        },
        {
            key: 'status',
            title: 'Status',
            accessor: ({ insurerPayment })=>getInsurerPaymentStatus(insurerPayment),
            style: {
                width: '30%'
            }
        }
    ]
};
const MultipageTableHeading = ({ title, style = textStyles.sectionTitle })=>{
    let firstPageOccurence = Number.MAX_SAFE_INTEGER;
    return /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        fixed: true,
        style: style,
        render: ({ pageNumber, subPageNumber })=>{
            if (pageNumber < firstPageOccurence && subPageNumber) {
                firstPageOccurence = pageNumber;
            }
            return pageNumber === firstPageOccurence ? title : `${title} cont...`;
        }
    });
};
const DataTableHeading = ({ columns, title })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        fixed: true
    }, title && /*#__PURE__*/ _react.default.createElement(MultipageTableHeading, {
        title: title
    }), /*#__PURE__*/ _react.default.createElement(Row, {
        wrap: false
    }, columns.map(({ key, title, style })=>/*#__PURE__*/ _react.default.createElement(HeaderCell, {
            key: key,
            style: style
        }, title))));
};
const DataTable = ({ data, columns, title })=>/*#__PURE__*/ _react.default.createElement(Table, null, /*#__PURE__*/ _react.default.createElement(DataTableHeading, {
        columns: columns,
        title: title
    }), data.map((row)=>/*#__PURE__*/ _react.default.createElement(Row, {
            key: row.id,
            wrap: false
        }, columns.map(({ key, accessor, style, CellComponent })=>{
            const displayValue = accessor ? accessor(row) : row[key] || '';
            if (CellComponent) {
                return /*#__PURE__*/ _react.default.createElement(CellComponent, {
                    key: key,
                    style: style
                }, displayValue);
            }
            return /*#__PURE__*/ _react.default.createElement(Cell, {
                key: key,
                style: style
            }, displayValue);
        }))));
const TableSection = ({ title, data, columns, type })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        minPresenceAhead: 70
    }), /*#__PURE__*/ _react.default.createElement(DataTable, {
        data: data,
        columns: columns,
        title: title,
        type: type
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null));
};
const SummaryPane = ({ invoice })=>{
    const { discountableItemsSubtotal, nonDiscountableItemsSubtotal, itemsSubtotal, patientSubtotal, patientDiscountableSubtotal, discountTotal, patientTotal } = (0, _invoice.getInvoiceSummaryDisplay)(invoice);
    const insurerDiscountAmountDisplayList = (0, _invoice.getInsurerDiscountAmountDisplayList)(invoice?.insurers, itemsSubtotal);
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        wrap: false,
        style: summaryPaneStyles.container
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, /*#__PURE__*/ _react.default.createElement(P, null, "Discountable items subtotal"), /*#__PURE__*/ _react.default.createElement(P, null, discountableItemsSubtotal ?? '-')), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, /*#__PURE__*/ _react.default.createElement(P, null, "Non-discountable items subtotal"), /*#__PURE__*/ _react.default.createElement(P, null, nonDiscountableItemsSubtotal ?? '-')), /*#__PURE__*/ _react.default.createElement(HorizontalRule, null), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, /*#__PURE__*/ _react.default.createElement(P, {
        isBold: true
    }, "Total"), /*#__PURE__*/ _react.default.createElement(P, {
        isBold: true
    }, itemsSubtotal ?? '-')), /*#__PURE__*/ _react.default.createElement(HorizontalRule, null), invoice?.insurers?.length && /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, /*#__PURE__*/ _react.default.createElement(P, {
        isBold: true
    }, "Insurer")), invoice?.insurers.map((insurer, index)=>{
        return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            key: insurer.id,
            style: summaryPaneStyles.item
        }, /*#__PURE__*/ _react.default.createElement(P, null, insurer.insurer?.name), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: summaryPaneStyles.subItem
        }, /*#__PURE__*/ _react.default.createElement(P, null, insurer.percentage * 100, "%"), /*#__PURE__*/ _react.default.createElement(P, null, `-${insurerDiscountAmountDisplayList[index]}`)));
    }), /*#__PURE__*/ _react.default.createElement(HorizontalRule, null)), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, /*#__PURE__*/ _react.default.createElement(P, {
        isBold: true
    }, "Patient subtotal"), /*#__PURE__*/ _react.default.createElement(P, null, patientSubtotal)), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, /*#__PURE__*/ _react.default.createElement(P, {
        isBold: true
    }, "Discount"), !!invoice.discount && /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.subItem
    }, /*#__PURE__*/ _react.default.createElement(P, null, invoice.discount?.percentage * 100, "%"), /*#__PURE__*/ _react.default.createElement(P, {
        isBold: true
    }, typeof discountTotal === 'string' ? `-${discountTotal}` : '-'))), !!invoice.discount && /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, invoice.discount?.isManual ? /*#__PURE__*/ _react.default.createElement(P, null, "Manual discount") : /*#__PURE__*/ _react.default.createElement(P, null, "Patient discount applied")), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, /*#__PURE__*/ _react.default.createElement(P, null, "Applied to discountable balance"), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.subItem
    }, /*#__PURE__*/ _react.default.createElement(P, null, patientDiscountableSubtotal ?? '-')))), /*#__PURE__*/ _react.default.createElement(HorizontalRule, null), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            summaryPaneStyles.item,
            {
                marginVertical: 7.5
            }
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, {
        isBold: true
    }, "Patient total"), /*#__PURE__*/ _react.default.createElement(P, {
        isBold: true
    }, patientTotal ?? '-')));
};
const InvoiceRecordPrintoutComponent = ({ patientData, encounter, certificateData, discharge, getLocalisation, clinicianText, invoice })=>{
    const { watermark, logo } = certificateData;
    const patientPayments = (0, _invoice.getPatientPaymentsWithRemainingBalanceDisplay)(invoice);
    const insurerPayments = (0, _invoice.getInsurerPaymentsWithRemainingBalanceDisplay)(invoice);
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: pageStyles.body,
        wrap: true
    }, watermark && /*#__PURE__*/ _react.default.createElement(_Layout.Watermark, {
        src: watermark
    }), /*#__PURE__*/ _react.default.createElement(_MultiPageHeader.MultiPageHeader, {
        documentName: `Invoice number: ${invoice.displayId}`,
        patientId: patientData.displayId,
        patientName: (0, _patientAccessors.getName)(patientData)
    }), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        logoSrc: logo,
        certificateTitle: `Invoice number: ${invoice.displayId}`,
        letterheadConfig: certificateData
    })), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), /*#__PURE__*/ _react.default.createElement(_PatientDetails.PatientDetails, {
        getLocalisation: getLocalisation,
        patient: patientData
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), /*#__PURE__*/ _react.default.createElement(_EncounterDetails.EncounterDetails, {
        encounter: encounter,
        discharge: discharge,
        clinicianText: clinicianText
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), /*#__PURE__*/ _react.default.createElement(_InvoiceDetails.InvoiceDetails, {
        encounter: encounter,
        invoice: invoice
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), invoice?.items?.length > 0 && /*#__PURE__*/ _react.default.createElement(TableSection, {
        data: invoice?.items,
        columns: COLUMNS.invoiceItems
    }), /*#__PURE__*/ _react.default.createElement(SummaryPane, {
        invoice: invoice
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), patientPayments?.length && /*#__PURE__*/ _react.default.createElement(TableSection, {
        title: "Patient payment",
        data: patientPayments,
        columns: COLUMNS.patientPayments
    }), insurerPayments?.length && /*#__PURE__*/ _react.default.createElement(TableSection, {
        title: "Insurer payment",
        data: insurerPayments,
        columns: COLUMNS.insurerPayments
    }), /*#__PURE__*/ _react.default.createElement(_Footer.Footer, null)));
};
const InvoiceRecordPrintout = (0, _languageContext.withLanguageContext)(InvoiceRecordPrintoutComponent);

//# sourceMappingURL=InvoiceRecordPrintout.js.map