"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PrescriptionPrintout", {
    enumerable: true,
    get: function() {
        return PrescriptionPrintout;
    }
});
const _renderer = require("@react-pdf/renderer");
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _constants = require("@tamanu/constants");
const _Layout = require("./Layout");
const _PatientDetailsWithBarcode = require("./printComponents/PatientDetailsWithBarcode");
const _Table = require("./Table");
const _DataSection = require("./printComponents/DataSection");
const _DataItem = require("./printComponents/DataItem");
const _getDisplayDate = require("./getDisplayDate");
const _dateTime = require("../dateTime");
const _LetterheadSection = require("./LetterheadSection");
const _Typography = require("./Typography");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const columns = [
    {
        key: 'medication',
        title: 'Medication',
        accessor: ({ medication })=>(medication || {}).name,
        customStyles: {
            minWidth: 100
        }
    },
    {
        key: 'prescription',
        title: 'Instructions',
        customStyles: {
            minWidth: 100
        }
    },
    {
        key: 'route',
        title: 'Route',
        accessor: ({ route })=>_constants.DRUG_ROUTE_LABELS[route] || ''
    },
    {
        key: 'quantity',
        title: 'Quantity'
    },
    {
        key: 'repeats',
        title: 'Repeats'
    }
];
const prescriptonSectionStyles = _renderer.StyleSheet.create({
    tableContainer: {
        marginTop: 12
    }
});
const notesSectionStyles = _renderer.StyleSheet.create({
    notesContainer: {
        border: '1px solid black',
        height: 69
    }
});
const signingSectionStyles = _renderer.StyleSheet.create({
    container: {
        marginTop: 22
    }
});
const generalStyles = _renderer.StyleSheet.create({
    container: {
        marginVertical: 8
    }
});
const SectionContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.container,
        ...props
    });
const PrescriptionsSection = ({ prescriptions, prescriber, facility, getLocalisation, getSetting })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        hideBottomRule: true,
        title: "Prescription details"
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Date",
        value: (0, _getDisplayDate.getDisplayDate)((0, _dateTime.getCurrentDateString)())
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Prescriber",
        value: prescriber?.displayName
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Prescriber ID",
        value: prescriber?.displayId ?? 'n/a'
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Facility",
        value: facility?.name
    }))), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: prescriptonSectionStyles.tableContainer
    }, /*#__PURE__*/ _react.default.createElement(_Table.Table, {
        columns: columns,
        data: prescriptions,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })));
};
const PrescriptionSigningSection = ()=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signingSectionStyles.container
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
        fontSize: 9,
        lineThickness: 0.5,
        text: "Signed"
    }), /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
        fontSize: 9,
        lineThickness: 0.5,
        text: "Date"
    }));
const NotesSection = ()=>/*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        bold: true,
        fontSize: 11,
        mb: 3
    }, "Notes"), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: notesSectionStyles.notesContainer
    }));
const PrescriptionPrintoutComponent = ({ patientData, prescriptions, prescriber, certificateData, facility, getLocalisation, getSetting })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: _Layout.styles.page
    }, /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        letterheadConfig: certificateData,
        logoSrc: certificateData.logo,
        certificateTitle: "Prescription"
    }), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_PatientDetailsWithBarcode.PatientDetailsWithBarcode, {
        patient: patientData,
        getLocalisation: getLocalisation
    }))), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateContent, null, /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(PrescriptionsSection, {
        prescriptions: prescriptions,
        prescriber: prescriber,
        facility: facility,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(NotesSection, null)), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(PrescriptionSigningSection, null)))));
};
const PrescriptionPrintout = (0, _languageContext.withLanguageContext)(PrescriptionPrintoutComponent);

//# sourceMappingURL=PrescriptionPrintout.js.map