"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    PatientLetter: function() {
        return PatientLetter;
    },
    getCreatedAtDate: function() {
        return getCreatedAtDate;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _Layout = require("../patientCertificates/Layout");
const _Typography = require("../patientCertificates/Typography");
const _LetterheadSection = require("../patientCertificates/LetterheadSection");
const _patientAccessors = require("../patientAccessors");
const _dateTime = require("../dateTime");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getCreatedAtDate = ({ documentCreatedAt })=>documentCreatedAt ? (0, _dateTime.format)(documentCreatedAt, 'dd/MM/yyyy') : 'Unknown';
const DETAIL_FIELDS = [
    {
        key: 'Patient name',
        label: 'Patient name',
        accessor: _patientAccessors.getName
    },
    {
        key: 'displayId',
        label: 'Patient ID'
    },
    {
        key: 'dateOfBirth',
        label: 'DOB',
        accessor: _patientAccessors.getDOB
    },
    {
        key: 'clinicianName',
        label: 'Clinician'
    },
    {
        key: 'sex',
        label: 'Sex',
        accessor: _patientAccessors.getSex
    },
    {
        key: 'documentCreatedAt',
        label: 'Date',
        accessor: getCreatedAtDate
    }
];
const detailsSectionStyle = {
    borderTop: '1 solid #000000',
    borderBottom: '1 solid #000000',
    paddingTop: 4,
    paddingBottom: 5,
    marginBottom: 10
};
const DetailsSection = ({ getLocalisation, data })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            marginTop: 10
        }
    }, /*#__PURE__*/ _react.default.createElement(_Typography.H3, {
        style: {
            marginBottom: 5
        }
    }, "Details"), /*#__PURE__*/ _react.default.createElement(_Layout.Row, {
        style: detailsSectionStyle
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, {
        style: {
            marginBottom: 5
        }
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, DETAIL_FIELDS.map(({ key, label: defaultLabel, accessor })=>{
        const value = (accessor ? accessor(data, getLocalisation) : data[key]) || '';
        const label = getTranslation(`general.localisedFields.${key}.label.short`) || getTranslation(`general.localisedFields.${key}.label`) || defaultLabel;
        return /*#__PURE__*/ _react.default.createElement(_Layout.Col, {
            style: {
                width: '50%'
            },
            key: key
        }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
            mb: 6
        }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
            bold: true
        }, label, ":"), " ", value));
    })))));
};
const PatientLetterComponent = ({ getLocalisation, data, logoSrc, letterheadConfig })=>{
    const { title: certificateTitle, body, patient = {}, clinician, documentCreatedAt } = data;
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: _Layout.styles.page
    }, /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        logoSrc: logoSrc,
        certificateTitle: certificateTitle ?? '',
        letterheadConfig: letterheadConfig
    }), /*#__PURE__*/ _react.default.createElement(DetailsSection, {
        data: {
            ...patient,
            clinicianName: clinician.displayName,
            documentCreatedAt
        },
        getLocalisation: getLocalisation
    })), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            margin: '18px'
        }
    }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        mb: 60,
        style: {
            fontSize: 12
        }
    }, body ?? ''), /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
        text: "Signed"
    }))));
};
const PatientLetter = (0, _languageContext.withLanguageContext)(PatientLetterComponent);

//# sourceMappingURL=PatientLetter.js.map