import React from 'react';
import { Col, LightDivider, Row } from './Layout';
import { H3, P } from './Typography';
import { getDOB, getSex, getVillageName } from '../patientAccessors';
import { useLanguageContext } from '../pdf/languageContext';
const patientFields = (getTranslation)=>[
        {
            key: 'firstName',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.firstName', 'First Name')
        },
        {
            key: 'displayId',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.patientId', 'Patient ID')
        },
        {
            key: 'lastName',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.lastName', 'Last Name')
        },
        {
            key: 'sex',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.sex', 'Sex'),
            accessor: getSex
        },
        {
            key: 'dateOfBirth',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.dob', 'DOB'),
            accessor: getDOB
        },
        {
            key: 'villageName',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.village', 'Village'),
            accessor: getVillageName
        }
    ];
export const PatientDetailsSection = ({ patient, getLocalisation, getSetting, extraFields = [] })=>{
    const { getTranslation } = useLanguageContext();
    const detailsToDisplay = [
        ...patientFields(getTranslation),
        ...extraFields
    ].filter(({ key })=>!getSetting(`fields.${key}.hidden`));
    return /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(H3, {
        style: {
            marginBottom: 0
        }
    }, getTranslation('pdf.vaccineCertificate.patientDetails.title', 'Patient Details')), /*#__PURE__*/ React.createElement(LightDivider, null), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, {
        style: {
            marginBottom: 5
        }
    }, /*#__PURE__*/ React.createElement(Row, null, detailsToDisplay.map(({ key, label: defaultLabel, accessor })=>{
        const value = (accessor ? accessor(patient, getLocalisation) : patient[key]) || '';
        const label = getTranslation(`general.localisedField.${key}.label.short`) || getTranslation(`general.localisedField.${key}.label`) || defaultLabel;
        return /*#__PURE__*/ React.createElement(Col, {
            style: {
                width: '50%'
            },
            key: key
        }, /*#__PURE__*/ React.createElement(P, {
            mb: 6,
            fontSize: 9
        }, /*#__PURE__*/ React.createElement(P, {
            bold: true,
            fontSize: 9
        }, label, ":"), ' ', value));
    })))), /*#__PURE__*/ React.createElement(LightDivider, null));
};

//# sourceMappingURL=PatientDetailsSection.js.map