"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    enumRegistry: function() {
        return enumRegistry;
    },
    enumTranslations: function() {
        return enumTranslations;
    },
    prefixMap: function() {
        return prefixMap;
    },
    registeredEnums: function() {
        return registeredEnums;
    },
    translationPrefixes: function() {
        return translationPrefixes;
    }
});
const _patientFields = require("./patientFields");
const _invoices = require("./invoices");
const _encounters = require("./encounters");
const _notes = require("./notes");
const _statuses = require("./statuses");
const _vaccines = require("./vaccines");
const _births = require("./births");
const _reports = require("./reports");
const _templates = require("./templates");
const _labs = require("./labs");
const _importable = require("./importable");
const _diagnoses = require("./diagnoses");
const _medications = require("./medications");
const _deaths = require("./deaths");
const _locations = require("./locations");
const _tasks = require("./tasks.js");
const _imaging = require("./imaging");
const _appointments = require("./appointments");
const registeredEnums = {
    APPOINTMENT_STATUSES: _statuses.APPOINTMENT_STATUSES,
    ATTENDANT_OF_BIRTH_LABELS: _births.ATTENDANT_OF_BIRTH_LABELS,
    ASSET_NAME_LABELS: _importable.ASSET_NAME_LABELS,
    BIRTH_DELIVERY_TYPE_LABELS: _births.BIRTH_DELIVERY_TYPE_LABELS,
    BIRTH_TYPE_LABELS: _births.BIRTH_TYPE_LABELS,
    BLOOD_LABELS: _patientFields.BLOOD_LABELS,
    DIAGNOSIS_CERTAINTY_LABELS: _diagnoses.DIAGNOSIS_CERTAINTY_LABELS,
    DRUG_ROUTE_LABELS: _medications.DRUG_ROUTE_LABELS,
    EDUCATIONAL_ATTAINMENT_LABELS: _patientFields.EDUCATIONAL_ATTAINMENT_LABELS,
    ENCOUNTER_TYPE_LABELS: _encounters.ENCOUNTER_TYPE_LABELS,
    IMAGING_TYPES: _imaging.IMAGING_TYPES,
    IMAGING_REQUEST_STATUS_LABELS: _statuses.IMAGING_REQUEST_STATUS_LABELS,
    INJECTION_SITE_LABELS: _vaccines.INJECTION_SITE_LABELS,
    INVOICE_INSURER_PAYMENT_STATUS_LABELS: _invoices.INVOICE_INSURER_PAYMENT_STATUS_LABELS,
    INVOICE_ITEMS_CATEGORY_LABELS: _invoices.INVOICE_ITEMS_CATEGORY_LABELS,
    INVOICE_PATIENT_PAYMENT_STATUSES_LABELS: _invoices.INVOICE_PATIENT_PAYMENT_STATUSES_LABELS,
    INVOICE_STATUS_LABELS: _invoices.INVOICE_STATUS_LABELS,
    LAB_REQUEST_STATUS_LABELS: _labs.LAB_REQUEST_STATUS_LABELS,
    LOCATION_AVAILABILITY_STATUS_LABELS: _locations.LOCATION_AVAILABILITY_STATUS_LABELS,
    MANNER_OF_DEATHS: _deaths.MANNER_OF_DEATHS,
    MARTIAL_STATUS_LABELS: _patientFields.MARTIAL_STATUS_LABELS,
    NOTE_TYPE_LABELS: _notes.NOTE_TYPE_LABELS,
    PATIENT_ISSUE_LABELS: _diagnoses.PATIENT_ISSUE_LABELS,
    PLACE_OF_BIRTH_LABELS: _births.PLACE_OF_BIRTH_LABELS,
    PLACE_OF_DEATHS: _deaths.PLACE_OF_DEATHS,
    REFERRAL_STATUS_LABELS: _statuses.REFERRAL_STATUS_LABELS,
    REPEATS_LABELS: _medications.REPEATS_LABELS,
    REPEAT_FREQUENCY_LABELS: _appointments.REPEAT_FREQUENCY_LABELS,
    REPEAT_FREQUENCY_UNIT_LABELS: _appointments.REPEAT_FREQUENCY_UNIT_LABELS,
    REPEAT_FREQUENCY_UNIT_PLURAL_LABELS: _appointments.REPEAT_FREQUENCY_UNIT_PLURAL_LABELS,
    REPORT_DATA_SOURCE_LABELS: _reports.REPORT_DATA_SOURCE_LABELS,
    REPORT_DB_SCHEMA_LABELS: _reports.REPORT_DB_SCHEMA_LABELS,
    REPORT_DEFAULT_DATE_RANGES_LABELS: _reports.REPORT_DEFAULT_DATE_RANGES_LABELS,
    REPORT_STATUS_LABELS: _reports.REPORT_STATUS_LABELS,
    SEX_LABELS: _patientFields.SEX_LABELS,
    TASK_FREQUENCY_UNIT_LABELS: _tasks.TASK_FREQUENCY_UNIT_LABELS,
    SOCIAL_MEDIA_LABELS: _patientFields.SOCIAL_MEDIA_LABELS,
    TEMPLATE_TYPE_LABELS: _templates.TEMPLATE_TYPE_LABELS,
    TITLE_LABELS: _patientFields.TITLE_LABELS,
    VACCINE_CATEGORY_LABELS: _vaccines.VACCINE_CATEGORY_LABELS,
    VACCINE_STATUS_LABELS: _vaccines.VACCINE_STATUS_LABELS
};
const translationPrefixes = {
    APPOINTMENT_STATUSES: 'appointment.property.status',
    ATTENDANT_OF_BIRTH_LABELS: 'birth.property.attendantOfBirth',
    ASSET_NAME_LABELS: 'asset.property.name',
    BIRTH_DELIVERY_TYPE_LABELS: 'birth.property.birthDeliveryType',
    BIRTH_TYPE_LABELS: 'birth.property.birthType',
    BLOOD_LABELS: 'patient.property.blood',
    DIAGNOSIS_CERTAINTY_LABELS: 'diagnosis.property.certainty',
    DRUG_ROUTE_LABELS: 'medication.property.route',
    EDUCATIONAL_ATTAINMENT_LABELS: 'patient.property.educationalAttainment',
    ENCOUNTER_TYPE_LABELS: 'encounter.property.type',
    IMAGING_TYPES: 'imaging.property.type',
    IMAGING_REQUEST_STATUS_LABELS: 'imaging.property.status',
    INJECTION_SITE_LABELS: 'vaccine.property.injectionSite',
    INVOICE_INSURER_PAYMENT_STATUS_LABELS: 'invoice.property.insurerPaymentStatus',
    INVOICE_ITEMS_CATEGORY_LABELS: 'invoice.property.itemCategory',
    INVOICE_PATIENT_PAYMENT_STATUSES_LABELS: 'invoice.property.patientPaymentStatus',
    INVOICE_STATUS_LABELS: 'invoice.property.status',
    LAB_REQUEST_STATUS_LABELS: 'lab.property.status',
    LOCATION_AVAILABILITY_STATUS_LABELS: 'bedManagement.property.status',
    MANNER_OF_DEATHS: 'death.property.mannerOfDeath',
    MARTIAL_STATUS_LABELS: 'patient.property.maritalStatus',
    NOTE_TYPE_LABELS: 'note.property.type',
    PATIENT_ISSUE_LABELS: 'patient.property.issue',
    PLACE_OF_BIRTH_LABELS: 'birth.property.placeOfBirth',
    PLACE_OF_DEATHS: 'death.property.placeOfDeath',
    REFERRAL_STATUS_LABELS: 'referral.property.status',
    REPEATS_LABELS: 'medication.property.repeats',
    REPEAT_FREQUENCY_LABELS: 'scheduling.property.repeatFrequency',
    REPEAT_FREQUENCY_UNIT_LABELS: 'scheduling.property.repeatFrequencyUnit',
    REPEAT_FREQUENCY_UNIT_PLURAL_LABELS: 'scheduling.property.repeatFrequencyUnitPlural',
    REPORT_DATA_SOURCE_LABELS: 'report.property.dataSource',
    REPORT_DB_SCHEMA_LABELS: 'report.property.schema',
    REPORT_DEFAULT_DATE_RANGES_LABELS: 'report.property.defaultDateRange',
    REPORT_STATUS_LABELS: 'report.property.status',
    SEX_LABELS: 'patient.property.sex',
    TASK_FREQUENCY_UNIT_LABELS: 'task.property.frequencyUnit',
    SOCIAL_MEDIA_LABELS: 'patient.property.socialMedia',
    TEMPLATE_TYPE_LABELS: 'template.property.type',
    TITLE_LABELS: 'patient.property.title',
    VACCINE_CATEGORY_LABELS: 'vaccine.property.category',
    VACCINE_STATUS_LABELS: 'vaccine.property.status'
};
const enumRegistry = new Set(Object.values(registeredEnums));
const prefixMap = new Map(Object.entries(registeredEnums).map(([key, enumValue])=>[
        enumValue,
        translationPrefixes[key]
    ]));
const enumTranslations = Object.entries(registeredEnums).flatMap(([key, value])=>Object.entries(value).map(([enumKey, enumValue])=>[
            `${translationPrefixes[key]}.${enumKey.toLowerCase().replace(/[^a-zA-Z0-9]+(.)/g, (_, char)=>char.toUpperCase())}`,
            enumValue
        ]));

//# sourceMappingURL=enumRegistry.js.map