"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    INVOICE_INSURER_PAYMENT_STATUSES: function() {
        return INVOICE_INSURER_PAYMENT_STATUSES;
    },
    INVOICE_INSURER_PAYMENT_STATUS_LABELS: function() {
        return INVOICE_INSURER_PAYMENT_STATUS_LABELS;
    },
    INVOICE_ITEMS_CATEGORY_LABELS: function() {
        return INVOICE_ITEMS_CATEGORY_LABELS;
    },
    INVOICE_ITEMS_DISCOUNT_TYPES: function() {
        return INVOICE_ITEMS_DISCOUNT_TYPES;
    },
    INVOICE_PATIENT_PAYMENT_STATUSES: function() {
        return INVOICE_PATIENT_PAYMENT_STATUSES;
    },
    INVOICE_PATIENT_PAYMENT_STATUSES_LABELS: function() {
        return INVOICE_PATIENT_PAYMENT_STATUSES_LABELS;
    },
    INVOICE_PAYMENT_STATUSES: function() {
        return INVOICE_PAYMENT_STATUSES;
    },
    INVOICE_STATUSES: function() {
        return INVOICE_STATUSES;
    },
    INVOICE_STATUS_LABELS: function() {
        return INVOICE_STATUS_LABELS;
    }
});
const _importable = require("./importable");
const INVOICE_STATUSES = {
    CANCELLED: 'cancelled',
    IN_PROGRESS: 'in_progress',
    FINALISED: 'finalised'
};
const INVOICE_STATUS_LABELS = {
    [INVOICE_STATUSES.CANCELLED]: 'Cancelled',
    [INVOICE_STATUSES.IN_PROGRESS]: 'In progress',
    [INVOICE_STATUSES.FINALISED]: 'Finalised'
};
const INVOICE_PAYMENT_STATUSES = {
    UNPAID: 'unpaid',
    PAID: 'paid',
    PARTIAL: 'partial',
    REJECTED: 'rejected',
    PAID_REJECTED: 'paid/rejected'
};
const INVOICE_ITEMS_CATEGORY_LABELS = {
    [_importable.REFERENCE_TYPES.PROCEDURE_TYPE]: 'Procedure',
    [_importable.REFERENCE_TYPES.IMAGING_TYPE]: 'Imaging',
    [_importable.OTHER_REFERENCE_TYPES.LAB_TEST_TYPE]: 'Lab test',
    [_importable.REFERENCE_TYPES.ADDITIONAL_INVOICE_PRODUCT]: 'Additional'
};
const INVOICE_ITEMS_DISCOUNT_TYPES = {
    PERCENTAGE: 'percentage',
    AMOUNT: 'amount'
};
const INVOICE_PATIENT_PAYMENT_STATUSES = {
    UNPAID: 'unpaid',
    PAID: 'paid',
    PARTIAL: 'partial'
};
const INVOICE_INSURER_PAYMENT_STATUSES = {
    UNPAID: 'unpaid',
    PAID: 'paid',
    PARTIAL: 'partial',
    REJECTED: 'rejected'
};
const INVOICE_PATIENT_PAYMENT_STATUSES_LABELS = {
    [INVOICE_PATIENT_PAYMENT_STATUSES.UNPAID]: 'Unpaid',
    [INVOICE_PATIENT_PAYMENT_STATUSES.PAID]: 'Paid',
    [INVOICE_PATIENT_PAYMENT_STATUSES.PARTIAL]: 'Partial'
};
const INVOICE_INSURER_PAYMENT_STATUS_LABELS = {
    [INVOICE_INSURER_PAYMENT_STATUSES.UNPAID]: 'Unpaid',
    [INVOICE_INSURER_PAYMENT_STATUSES.PAID]: 'Paid',
    [INVOICE_INSURER_PAYMENT_STATUSES.PARTIAL]: 'Partial',
    [INVOICE_INSURER_PAYMENT_STATUSES.REJECTED]: 'Rejected'
};

//# sourceMappingURL=invoices.js.map