/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.dropTable('invoice_price_change_items');
    await query.dropTable('invoice_price_change_types');
    await query.dropTable('invoice_line_items');
    await query.dropTable('invoice_line_types');
    await query.dropTable('invoices');
    await query.createTable('invoice_products', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true
        },
        name: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        price: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        },
        discountable: {
            // only apply for invoice discount, not item discount
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true,
            defaultValue: _sequelize.DataTypes.NOW
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('invoices', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        display_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        date: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        status: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        payment_status: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        receipt_number: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        encounter_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'encounters',
                key: 'id'
            }
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('invoice_discounts', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        invoice_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'invoices',
                key: 'id'
            }
        },
        percentage: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        },
        reason: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        is_manual: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false
        },
        applied_by_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        applied_time: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true,
            defaultValue: _sequelize.DataTypes.NOW
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('invoice_insurers', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        invoice_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'invoices',
                key: 'id'
            }
        },
        insurer_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        percentage: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true,
            defaultValue: _sequelize.DataTypes.NOW
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('invoice_items', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        invoice_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'invoices',
                key: 'id'
            }
        },
        order_date: {
            type: _sequelize.DataTypes.DATESTRING,
            allowNull: false
        },
        product_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'invoice_products',
                key: 'id'
            }
        },
        quantity: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: false
        },
        product_name: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        product_price: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: true
        },
        ordered_by_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        source_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true,
            defaultValue: _sequelize.DataTypes.NOW
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('invoice_item_discounts', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        invoice_item_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'invoice_items',
                key: 'id'
            }
        },
        percentage: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        },
        reason: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true,
            defaultValue: _sequelize.DataTypes.NOW
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.addColumn('invoice_items', 'product_code', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
// await query.addIndex('invoices', ['encounter_id'], {
//   where: { deleted_at: null },
//   unique: true,
//   name: 'invoices_encounter_id_unique',
// });
// await query.addIndex('invoice_discounts', ['invoice_id'], {
//   where: { deleted_at: null },
//   unique: true,
//   name: 'invoice_discounts_invoice_id_unique',
// });
// await query.addIndex('invoice_item_discounts', ['invoice_item_id'], {
//   where: { deleted_at: null },
//   unique: true,
//   name: 'invoice_item_discounts_invoice_item_id_unique',
// });
}
async function down(query) {
    await query.removeColumn('invoice_items', 'product_code');
    // await query.removeIndex('invoices', 'invoices_encounter_id_unique');
    // await query.removeIndex('invoice_discounts', 'invoice_discounts_invoice_id_unique');
    // await query.removeIndex(
    //   'invoice_item_discounts',
    //   'invoice_item_discounts_invoice_item_id_unique',
    // );
    await query.dropTable('invoice_item_discounts', {});
    await query.dropTable('invoice_items');
    await query.dropTable('invoice_insurers');
    await query.dropTable('invoice_discounts');
    await query.dropTable('invoice_products');
    await query.dropTable('invoices');
    await query.createTable('invoices', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true
        },
        display_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        encounter_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'encounters',
                key: 'id'
            }
        },
        total: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: true
        },
        status: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        payment_status: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        receipt_number: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: true
        },
        date: {
            type: 'date_string',
            allowNull: true
        },
        date_legacy: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        discount_markup_percentage: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: true
        },
        discount_markup_reason: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.DataTypes.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('invoice_line_types', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true
        },
        item_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        item_type: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        name: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        price: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.DataTypes.NOW,
            allowNull: true
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('invoice_line_items', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true
        },
        invoice_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'invoices',
                key: 'id'
            }
        },
        invoice_line_type_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'invoice_line_types',
                key: 'id'
            }
        },
        date_generated: {
            type: 'date_string',
            allowNull: false
        },
        date_generated_legacy: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        percentage_change: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        },
        discount_markup_reason: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        status: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.DataTypes.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('invoice_price_change_types', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true
        },
        item_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        item_type: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        name: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        percentage_change: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.DataTypes.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('invoice_price_change_items', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true
        },
        invoice_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'invoices',
                key: 'id'
            }
        },
        invoice_price_change_type_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'invoice_price_change_types',
                key: 'id'
            }
        },
        ordered_by_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        date: {
            type: 'date_string',
            allowNull: false
        },
        date_legacy: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        description: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        percentage_change: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: true
        },
        status: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.DataTypes.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
}

//# sourceMappingURL=1717995742385-updateInvoicingTables.js.map