"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "OneTimeLogin", {
    enumerable: true,
    get: function() {
        return OneTimeLogin;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let OneTimeLogin = class OneTimeLogin extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            token: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            expiresAt: {
                type: _sequelize.DataTypes.DATE,
                allowNull: false
            },
            usedAt: {
                type: _sequelize.DataTypes.DATE,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC
        });
    }
    isExpired() {
        return this.expiresAt < new Date();
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: {
                name: 'userId',
                allowNull: false
            },
            as: 'user'
        });
    }
};

//# sourceMappingURL=OneTimeLogin.js.map