"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SyncSession", {
    enumerable: true,
    get: function() {
        return SyncSession;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let SyncSession = class SyncSession extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            startTime: {
                type: _sequelize.DataTypes.DATE
            },
            lastConnectionTime: {
                type: _sequelize.DataTypes.DATE
            },
            snapshotStartedAt: {
                type: _sequelize.DataTypes.DATE
            },
            snapshotCompletedAt: {
                type: _sequelize.DataTypes.DATE
            },
            persistCompletedAt: {
                type: _sequelize.DataTypes.DATE
            },
            completedAt: {
                type: _sequelize.DataTypes.DATE
            },
            startedAtTick: {
                type: _sequelize.DataTypes.BIGINT
            },
            pullSince: {
                type: _sequelize.DataTypes.BIGINT
            },
            pullUntil: {
                type: _sequelize.DataTypes.BIGINT
            },
            errors: {
                type: _sequelize.DataTypes.ARRAY(_sequelize.DataTypes.TEXT)
            },
            debugInfo: {
                type: _sequelize.DataTypes.JSON
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC
        });
    }
    static async addDebugInfo(id, info) {
        const session = await this.findOne({
            where: {
                id
            }
        });
        await session?.update({
            debugInfo: {
                ...session.debugInfo,
                ...info
            }
        });
    }
    /**
   * @param {number} tick sync tick
   */ async markAsStartedAt(tick) {
        return this.sequelize.models.SyncSession?.update({
            startedAtTick: tick
        }, {
            where: {
                id: this.id
            }
        });
    }
    async markErrored(error) {
        const errors = this.errors || [];
        await this.update({
            errors: [
                ...errors,
                error
            ],
            completedAt: new Date()
        });
    }
    static async markSessionErrored(id, error) {
        const session = await this.findByPk(id);
        await session?.markErrored(error);
    }
};

//# sourceMappingURL=SyncSession.js.map