import { Model } from './Model';
import type { InitOptions } from '../types/model';
export declare class TranslatedString extends Model {
    id: string;
    stringId: string;
    language: string;
    text: string;
    static initModel(options: InitOptions): void;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
    static getPossibleLanguages: () => Promise<{
        languagesInDb: TranslatedString[];
        languageNames: TranslatedString[];
    }>;
    static getReferenceDataTranslationsByDataType: ({ language, refDataType, queryString, limit, }: {
        language: string;
        refDataType: string;
        queryString: string;
        limit: number;
    }) => Promise<TranslatedString[]>;
    static getTranslations: (language: string, prefixIds: string[]) => Promise<import("lodash").Dictionary<string>>;
    static getTranslationFunction: (language: string, prefixIds?: string[]) => Promise<(stringId: string, fallback: string, replacements: Record<string, string>, uppercase: boolean, lowercase: boolean) => string>;
}
//# sourceMappingURL=TranslatedString.d.ts.map