import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
import type { Facility } from './Facility';
import type { LocationGroup } from './LocationGroup';
export declare class Location extends Model {
    id: string;
    code: string;
    name: string;
    visibilityStatus: string;
    maxOccupancy?: number;
    facilityId?: string;
    locationGroupId?: string;
    deletedAt?: Date;
    facility?: Facility;
    locationGroup?: LocationGroup;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static formatFullLocationName({ locationGroup, name }: Location): string;
    static parseFullLocationName(text: string): {
        group: string | undefined;
        location: string | undefined;
    };
    getAvailability(): Promise<string>;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
}
//# sourceMappingURL=Location.d.ts.map