import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
export class OneTimeLogin extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            token: {
                type: DataTypes.STRING,
                allowNull: false
            },
            expiresAt: {
                type: DataTypes.DATE,
                allowNull: false
            },
            usedAt: {
                type: DataTypes.DATE,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.DO_NOT_SYNC
        });
    }
    isExpired() {
        return this.expiresAt < new Date();
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: {
                name: 'userId',
                allowNull: false
            },
            as: 'user'
        });
    }
}

//# sourceMappingURL=OneTimeLogin.js.map