"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getReportQueryReplacements", {
    enumerable: true,
    get: function() {
        return getReportQueryReplacements;
    }
});
const _datefns = require("date-fns");
const _constants = require("@tamanu/constants");
const CATCH_ALL_FROM_DATE = '1970-01-01';
function getStartDate(dateRange, endDate) {
    switch(dateRange){
        case _constants.REPORT_DEFAULT_DATE_RANGES.ALL_TIME:
            return new Date(CATCH_ALL_FROM_DATE);
        case _constants.REPORT_DEFAULT_DATE_RANGES.EIGHTEEN_YEARS:
            return (0, _datefns.startOfDay)((0, _datefns.subYears)(endDate, 18));
        case _constants.REPORT_DEFAULT_DATE_RANGES.THIRTY_DAYS:
            // If we have a toDate, but no fromDate, run 30 days prior to the toDate
            return (0, _datefns.startOfDay)((0, _datefns.subDays)(endDate, 30));
        case _constants.REPORT_DEFAULT_DATE_RANGES.SEVEN_DAYS:
            return (0, _datefns.startOfDay)((0, _datefns.subDays)(endDate, 7));
        case _constants.REPORT_DEFAULT_DATE_RANGES.TWENTY_FOUR_HOURS:
            return (0, _datefns.subDays)(endDate, 1);
        case _constants.REPORT_DEFAULT_DATE_RANGES.NEXT_THIRTY_DAYS:
            return new Date();
        default:
            throw new Error('Unknown date range for report generation');
    }
}
function getEndDate(dateRange, fromDate) {
    switch(dateRange){
        case _constants.REPORT_DEFAULT_DATE_RANGES.ALL_TIME:
        case _constants.REPORT_DEFAULT_DATE_RANGES.EIGHTEEN_YEARS:
        case _constants.REPORT_DEFAULT_DATE_RANGES.THIRTY_DAYS:
        case _constants.REPORT_DEFAULT_DATE_RANGES.SEVEN_DAYS:
        case _constants.REPORT_DEFAULT_DATE_RANGES.TWENTY_FOUR_HOURS:
            return new Date();
        case _constants.REPORT_DEFAULT_DATE_RANGES.NEXT_THIRTY_DAYS:
            return (0, _datefns.endOfDay)((0, _datefns.addDays)(fromDate || new Date(), 30));
        default:
            throw new Error('Unknown date range for report generation');
    }
}
const getReportQueryReplacements = async (paramDefinitions, facilityId, params = {}, dateRange = _constants.REPORT_DEFAULT_DATE_RANGES.TWENTY_FOUR_HOURS)=>{
    let toDate;
    if (params.toDate) {
        toDate = new Date(params.toDate);
    } else {
        toDate = getEndDate(dateRange, params.fromDate ? new Date(params.fromDate) : new Date());
    }
    const fromDate = params.fromDate ? (0, _datefns.parseISO)(params.fromDate) : getStartDate(dateRange, toDate);
    const paramDefaults = paramDefinitions.reduce((obj, { name })=>({
            ...obj,
            [name]: null
        }), {});
    return {
        ...paramDefaults,
        ...params,
        currentFacilityId: facilityId,
        fromDate,
        toDate
    };
};

//# sourceMappingURL=getReportQueryReplacements.js.map