"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    replaceStringVariables: function() {
        return replaceStringVariables;
    },
    translationFactory: function() {
        return translationFactory;
    }
});
const _lodash = require("lodash");
const applyCasing = (text, uppercase, lowercase, upperFirst)=>{
    if (lowercase) return text.toLowerCase();
    if (uppercase) return text.toUpperCase();
    if (upperFirst) return (0, _lodash.upperFirst)(text);
    return text;
};
const replaceStringVariables = (templateString, { replacements, uppercase, lowercase, upperFirst }, translations)=>{
    if (!replacements) return applyCasing(templateString, uppercase, lowercase, upperFirst);
    const result = templateString.split(/(:[a-zA-Z]+)/g).map((part, index)=>{
        // Even indexes are the unchanged parts of the string
        if (index % 2 === 0) return part;
        // Return the replacement if exists
        let replacement = replacements[part.slice(1)] || part;
        if (typeof replacement !== 'object') return replacement;
        const translation = translations?.[replacement.props.stringId] || replacement.props.fallback;
        return applyCasing(translation, replacement.props.uppercase, replacement.props.lowercase, replacement.props.upperFirst);
    }).join('');
    return applyCasing(result, uppercase, lowercase);
};
const translationFactory = (translations)=>(stringId, fallback, replacements, uppercase, lowercase, upperFirst)=>{
        const replacementConfig = {
            replacements,
            uppercase,
            lowercase,
            upperFirst
        };
        if (!translations) return {
            value: replaceStringVariables(fallback, replacementConfig, translations)
        };
        const translation = translations[stringId] ?? fallback;
        return {
            value: replaceStringVariables(translation, replacementConfig, translations),
            notExisting: !translations[stringId]
        };
    };

//# sourceMappingURL=translationFactory.js.map