"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    eachWeekdayInMonth: function() {
        return eachWeekdayInMonth;
    },
    getWeekdayOrdinalPosition: function() {
        return getWeekdayOrdinalPosition;
    },
    weekdayAtOrdinalPosition: function() {
        return weekdayAtOrdinalPosition;
    }
});
const _constants = require("@tamanu/constants");
const _datefns = require("date-fns");
const _dateTime = require("./dateTime");
const eachWeekdayInMonth = (date, weekday = date.getDay())=>(0, _dateTime.eachDayInMonth)(date).filter((day)=>day.getDay() === weekday);
const weekdayAtOrdinalPosition = (date, day, nth)=>{
    const matchingWeekdays = eachWeekdayInMonth(date, _constants.DAYS_OF_WEEK.indexOf(day));
    // Convert ordinal positioning to 0-based index but leave -1 as last occurrence
    const atIndex = Math.max(nth - 1, -1);
    const matchingWeekday = matchingWeekdays.at(atIndex);
    if (!matchingWeekday) {
        throw new Error('No weekday found at the specified ordinal position');
    }
    return matchingWeekday;
};
const getWeekdayOrdinalPosition = (date)=>{
    const matchingWeekdays = eachWeekdayInMonth(date);
    // Ordinal positioning is 1-based, -1 means the date is the last occurrence of the weekday in the month
    const nthWeekday = matchingWeekdays.findIndex((day)=>(0, _datefns.isSameDay)(day, date)) + 1;
    return nthWeekday === matchingWeekdays.length ? -1 : nthWeekday;
};

//# sourceMappingURL=appointmentScheduling.js.map