import React from 'react';
import { Document, View } from '@react-pdf/renderer';
import { CertificateHeader, Col, Row, Signature, styles } from '../patientCertificates/Layout';
import { H3, P } from '../patientCertificates/Typography';
import { LetterheadSection } from '../patientCertificates/LetterheadSection';
import { getDob, getName, getSex } from '../patientAccessors';
import { format as formatDate } from '@tamanu/utils/dateTime';
import { useLanguageContext, withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
export const getCreatedAtDate = ({ documentCreatedAt })=>documentCreatedAt ? formatDate(documentCreatedAt, 'dd/MM/yyyy') : 'Unknown';
const DETAIL_FIELDS = [
    {
        key: 'Patient name',
        label: 'Patient name',
        accessor: getName
    },
    {
        key: 'displayId',
        label: 'Patient ID'
    },
    {
        key: 'dateOfBirth',
        label: 'DOB',
        accessor: getDob
    },
    {
        key: 'clinicianName',
        label: 'Clinician'
    },
    {
        key: 'sex',
        label: 'Sex',
        accessor: getSex
    },
    {
        key: 'documentCreatedAt',
        label: 'Date',
        accessor: getCreatedAtDate
    }
];
const detailsSectionStyle = {
    borderTop: '1 solid #000000',
    borderBottom: '1 solid #000000',
    paddingTop: 4,
    paddingBottom: 5,
    marginBottom: 10
};
const DetailsSection = ({ getLocalisation, data })=>{
    const { getTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(View, {
        style: {
            marginTop: 10
        }
    }, /*#__PURE__*/ React.createElement(H3, {
        style: {
            marginBottom: 5
        }
    }, "Details"), /*#__PURE__*/ React.createElement(Row, {
        style: detailsSectionStyle
    }, /*#__PURE__*/ React.createElement(Col, {
        style: {
            marginBottom: 5
        }
    }, /*#__PURE__*/ React.createElement(Row, null, DETAIL_FIELDS.map(({ key, label: defaultLabel, accessor })=>{
        const value = (accessor ? accessor(data, {
            getLocalisation,
            getTranslation
        }) : data[key]) || '';
        const label = getTranslation(`general.localisedFields.${key}.label.short`) || getTranslation(`general.localisedFields.${key}.label`) || defaultLabel;
        return /*#__PURE__*/ React.createElement(Col, {
            style: {
                width: '50%'
            },
            key: key
        }, /*#__PURE__*/ React.createElement(P, {
            mb: 6
        }, /*#__PURE__*/ React.createElement(P, {
            bold: true
        }, label, ":"), " ", value));
    })))));
};
const PatientLetterComponent = ({ getLocalisation, data, logoSrc, letterheadConfig })=>{
    const { title: certificateTitle, body, patient = {}, clinician, documentCreatedAt } = data;
    return /*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: "A4",
        style: styles.page
    }, /*#__PURE__*/ React.createElement(CertificateHeader, null, /*#__PURE__*/ React.createElement(LetterheadSection, {
        logoSrc: logoSrc,
        certificateTitle: certificateTitle ?? '',
        letterheadConfig: letterheadConfig
    }), /*#__PURE__*/ React.createElement(DetailsSection, {
        data: {
            ...patient,
            clinicianName: clinician.displayName,
            documentCreatedAt
        },
        getLocalisation: getLocalisation
    })), /*#__PURE__*/ React.createElement(View, {
        style: {
            margin: '18px'
        }
    }, /*#__PURE__*/ React.createElement(P, {
        mb: 60,
        style: {
            fontSize: 12
        }
    }, body ?? ''), /*#__PURE__*/ React.createElement(Signature, {
        text: "Signed"
    }))));
};
export const PatientLetter = withLanguageContext(PatientLetterComponent);

//# sourceMappingURL=PatientLetter.js.map