"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    centralDefaults: function() {
        return centralDefaults;
    },
    centralSettings: function() {
        return centralSettings;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _definitions = require("./definitions");
const _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const centralSettings = {
    name: 'Central server settings',
    description: 'Settings that apply only to a central server',
    properties: {
        disk: {
            name: 'Disk',
            description: 'Disk settings',
            properties: {
                freeSpaceRequired: {
                    name: 'Free space required',
                    description: 'Settings related to free disk space required during uploads',
                    properties: {
                        gigabytesForUploadingDocuments: {
                            name: 'Gigabytes for uploading documents',
                            description: 'The minimum gigabytes required to upload documents',
                            type: _yup.number().positive(),
                            defaultValue: 16
                        }
                    }
                }
            }
        },
        questionCodeIds: {
            deprecated: true,
            description: _definitions.questionCodeIdsDescription,
            properties: {
                passport: {
                    type: _definitions.passportSchema,
                    defaultValue: null
                },
                nationalityId: {
                    type: _definitions.nationalityIdSchema,
                    defaultValue: null
                },
                email: {
                    type: _definitions.emailSchema,
                    defaultValue: null
                }
            }
        },
        reportProcess: {
            properties: {
                timeOutDurationSeconds: {
                    description: 'If generating a report takes longer than this, it will be cancelled and marked as timed out. (If this ' + 'is set to a very short duration shorter than the time between Report Request Processor runs ' + '(‘schedules.reportRequestProcessor’), it will have no effect.',
                    type: _yup.number().integer().positive(),
                    defaultValue: 7200,
                    unit: 'seconds'
                },
                runInChildProcess: {
                    description: 'True if report generation should be run in a child process, or false if it should run in the main process',
                    type: _yup.boolean(),
                    defaultValue: true
                },
                processOptions: {
                    description: "Provide an array if you want to override the options. e.g. ['--max-old-space-size=4096']",
                    type: _yup.array(_yup.string()).nullable(),
                    defaultValue: null
                },
                childProcessEnv: {
                    description: 'Provide an object {} for the env of child process',
                    type: _yup.object().nullable(),
                    defaultValue: null
                },
                sleepAfterReport: {
                    description: 'To mitigate resource-hungry reports affecting operational use of Tamanu, if a report takes too long, then report generation can be suspended for a some time',
                    properties: {
                        duration: {
                            description: 'If generating a report takes longer than ifRunAtLeast, then suspend subsequent report generation for this long',
                            type: (0, _definitions.durationStringSchema)('duration'),
                            defaultValue: '5m'
                        },
                        ifRunAtLeast: {
                            description: 'If a report takes longer than this, then temporarily suspend subsequent report generation',
                            type: (0, _definitions.durationStringSchema)('ifRunAtLeast'),
                            defaultValue: '5m'
                        }
                    }
                }
            }
        }
    }
};
const centralDefaults = (0, _utils.extractDefaults)(centralSettings);

//# sourceMappingURL=central.js.map