"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    chance: function() {
        return chance;
    },
    fake: function() {
        return fake;
    },
    fakeAdministeredVaccine: function() {
        return fakeAdministeredVaccine;
    },
    fakeBool: function() {
        return fakeBool;
    },
    fakeDate: function() {
        return fakeDate;
    },
    fakeDateString: function() {
        return fakeDateString;
    },
    fakeDateTimeString: function() {
        return fakeDateTimeString;
    },
    fakeEncounter: function() {
        return fakeEncounter;
    },
    fakeEncounterDiagnosis: function() {
        return fakeEncounterDiagnosis;
    },
    fakeEncounterMedication: function() {
        return fakeEncounterMedication;
    },
    fakeFloat: function() {
        return fakeFloat;
    },
    fakeInt: function() {
        return fakeInt;
    },
    fakeProgram: function() {
        return fakeProgram;
    },
    fakeProgramDataElement: function() {
        return fakeProgramDataElement;
    },
    fakeReferenceData: function() {
        return fakeReferenceData;
    },
    fakeScheduledVaccine: function() {
        return fakeScheduledVaccine;
    },
    fakeString: function() {
        return fakeString;
    },
    fakeStringFields: function() {
        return fakeStringFields;
    },
    fakeSurvey: function() {
        return fakeSurvey;
    },
    fakeSurveyResponse: function() {
        return fakeSurveyResponse;
    },
    fakeSurveyResponseAnswer: function() {
        return fakeSurveyResponseAnswer;
    },
    fakeSurveyScreenComponent: function() {
        return fakeSurveyScreenComponent;
    },
    fakeUser: function() {
        return fakeUser;
    }
});
const _lodash = require("lodash");
const _chance = /*#__PURE__*/ _interop_require_default(require("chance"));
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
const _util = require("util");
const _datefns = require("date-fns");
const _constants = require("@tamanu/constants");
const _dateTime = require("@tamanu/utils/dateTime");
const _generateId = require("@tamanu/utils/generateId");
const _fhirTypes = require("../services/fhirTypes");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const chance = new _chance.default(global.jest ? jest.getSeed() : null);
function fakeStringFields(prefix, fields) {
    return fields.reduce((obj, field)=>({
            ...obj,
            [field]: prefix + field
        }), {});
}
function fakeScheduledVaccine(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return {
        weeksFromBirthDue: chance.integer({
            min: 0,
            max: 1000
        }),
        weeksFromLastVaccinationDue: null,
        index: chance.integer({
            min: 0,
            max: 50
        }),
        vaccineId: null,
        visibilityStatus: _constants.VISIBILITY_STATUSES.CURRENT,
        sortIndex: 0,
        ...fakeStringFields(`${prefix}scheduledVaccine_${id}_`, [
            'id',
            'category',
            'label',
            'doseLabel'
        ])
    };
}
function fakeSurvey(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return {
        programId: null,
        surveyType: 'programs',
        isSensitive: false,
        ...fakeStringFields(`${prefix}survey_${id}_`, [
            'id',
            'code',
            'name'
        ])
    };
}
function fakeSurveyScreenComponent(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return {
        surveyId: null,
        dataElementId: null,
        screenIndex: chance.integer({
            min: 0,
            max: 100
        }),
        componentIndex: chance.integer({
            min: 0,
            max: 100
        }),
        options: '{"foo":"bar"}',
        calculation: '',
        ...fakeStringFields(`${prefix}surveyScreenComponent_${id}_`, [
            'id',
            'text',
            'visibilityCriteria',
            'validationCriteria',
            'detail',
            'config'
        ])
    };
}
function fakeProgramDataElement(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return {
        type: chance.pickone(_constants.PROGRAM_DATA_ELEMENT_TYPE_VALUES),
        ...fakeStringFields(`${prefix}programDataElement_${id}_`, [
            'id',
            'code',
            'name',
            'indicator',
            'defaultText',
            'defaultOptions'
        ])
    };
}
function fakeReferenceData(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return {
        type: chance.pickone(_constants.REFERENCE_TYPE_VALUES),
        visibilityStatus: _constants.VISIBILITY_STATUSES.CURRENT,
        ...fakeStringFields(`${prefix}referenceData_${id}_`, [
            'id',
            'name',
            'code'
        ])
    };
}
function fakeUser(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return fakeStringFields(`${prefix}user_${id}_`, [
        'id',
        'displayId',
        'email',
        'displayName',
        'role'
    ]);
}
function fakeProgram(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return fakeStringFields(`${prefix}program_${id})_`, [
        'id',
        'name',
        'code'
    ]);
}
function fakeAdministeredVaccine(prefix = 'test-', scheduledVaccineId) {
    const id = (0, _generateId.fakeUUID)();
    return {
        encounterId: null,
        scheduledVaccineId,
        date: (0, _datefns.formatISO9075)(chance.date()),
        ...fakeStringFields(`${prefix}administeredVaccine_${id}_`, [
            'id',
            'batch',
            'status',
            'reason'
        ])
    };
}
function fakeEncounter(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return {
        deviceId: null,
        surveyResponses: [],
        administeredVaccines: [],
        encounterType: chance.pickone(_constants.ENCOUNTER_TYPE_VALUES),
        startDate: (0, _datefns.formatISO9075)(chance.date()),
        endDate: (0, _datefns.formatISO9075)(chance.date()),
        ...fakeStringFields(`${prefix}encounter_${id}_`, [
            'id',
            'reasonForEncounter'
        ])
    };
}
function fakeSurveyResponse(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return {
        answers: [],
        encounterId: null,
        surveyId: null,
        startTime: fakeDateTimeString(),
        endTime: fakeDateTimeString(),
        result: chance.floating({
            min: 0,
            max: 100
        }),
        ...fakeStringFields(`${prefix}surveyResponse_${id}_`, [
            'id'
        ])
    };
}
function fakeSurveyResponseAnswer(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return {
        dataElementId: null,
        responseId: null,
        ...fakeStringFields(`${prefix}surveyResponseAnswer_${id}_`, [
            'id',
            'name',
            'body'
        ])
    };
}
function fakeEncounterDiagnosis(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return {
        certainty: chance.pickone(_constants.DIAGNOSIS_CERTAINTY_VALUES),
        date: (0, _datefns.formatISO9075)(chance.date()),
        isPrimary: chance.bool(),
        encounterId: null,
        diagnosisId: null,
        ...fakeStringFields(`${prefix}encounterDiagnosis_${id}_`, [
            'id'
        ])
    };
}
function fakeEncounterMedication(prefix = 'test-') {
    const id = (0, _generateId.fakeUUID)();
    return {
        date: (0, _datefns.formatISO9075)(chance.date()),
        endDate: (0, _datefns.formatISO9075)(chance.date()),
        qtyMorning: chance.integer({
            min: 0,
            max: 10
        }),
        qtyLunch: chance.integer({
            min: 0,
            max: 10
        }),
        qtyEvening: chance.integer({
            min: 0,
            max: 10
        }),
        qtyNight: chance.integer({
            min: 0,
            max: 10
        }),
        ...fakeStringFields(`${prefix}encounterMedication_${id}_`, [
            'id',
            'prescription',
            'note',
            'indication',
            'route'
        ])
    };
}
const fakeDate = ()=>chance.date();
const fakeString = (model, { fieldName }, id)=>`${model.name}.${fieldName}.${id}`;
const fakeDateTimeString = ()=>(0, _dateTime.toDateTimeString)(fakeDate());
const fakeDateString = ()=>(0, _dateTime.toDateString)(fakeDate());
const fakeInt = ()=>chance.integer({
        min: 0,
        max: 10
    });
const fakeFloat = ()=>chance.floating({
        min: 0,
        max: 1000
    });
const fakeBool = ()=>chance.bool();
const FIELD_HANDLERS = {
    'TIMESTAMP WITH TIME ZONE': fakeDate,
    'TIMESTAMP WITHOUT TIME ZONE': fakeDate,
    DATETIME: fakeDate,
    TIMESTAMP: fakeDate,
    // custom type used for datetime string storage
    date_time_string: fakeDateTimeString,
    DATETIMESTRING: fakeDateTimeString,
    // custom type used for date string storage
    date_string: fakeDateString,
    DATESTRING: fakeDateString,
    'VARCHAR(19)': fakeDateString,
    'VARCHAR(255)': fakeString,
    // fallback for all other varchar lengths
    'VARCHAR(N)': (model, attrs, id, length)=>fakeString(model, attrs, id).slice(0, length),
    TEXT: fakeString,
    INTEGER: fakeInt,
    FLOAT: fakeFloat,
    DECIMAL: fakeFloat,
    'TINYINT(1)': fakeBool,
    BOOLEAN: fakeBool,
    ENUM: (model, { type })=>chance.pickone(type.values),
    UUID: ()=>(0, _generateId.fakeUUID)()
};
const IGNORED_FIELDS = [
    'createdAt',
    'updatedAt',
    'deletedAt',
    'updatedAtSyncTick'
];
const MODEL_SPECIFIC_OVERRIDES = {
    Facility: ()=>({
            email: chance.email(),
            contactNumber: chance.phone(),
            streetAddress: `${chance.natural({
                max: 999
            })} ${chance.street()}`,
            cityTown: chance.city(),
            division: chance.province({
                full: true
            }),
            type: chance.pickone([
                'hospital',
                'clinic'
            ])
        }),
    ImagingRequest: ()=>{
        const status = chance.pickone(Object.values(_constants.IMAGING_REQUEST_STATUS_TYPES));
        const isCancelled = status === _constants.IMAGING_REQUEST_STATUS_TYPES.CANCELLED;
        return {
            status,
            reasonForCancellation: isCancelled ? chance.pickone([
                'duplicate',
                'entered-in-error'
            ]) : null
        };
    },
    LabTestType: ()=>{
        return {
            code: chance.word(),
            name: chance.word(),
            unit: chance.pickone([
                'mmol/L',
                'umol/L',
                'IU'
            ]),
            isSensitive: false,
            externalCode: chance.pickone([
                chance.word(),
                null
            ])
        };
    },
    LabRequest: ()=>{
        const status = chance.pickone(Object.values(_constants.LAB_REQUEST_STATUSES));
        const isCancelled = status === _constants.LAB_REQUEST_STATUSES.CANCELLED;
        return {
            status,
            reasonForCancellation: isCancelled ? chance.pickone([
                'duplicate',
                'entered-in-error'
            ]) : null
        };
    },
    Patient: ()=>{
        const sex = chance.pickone([
            'male',
            'female',
            'other'
        ]);
        let nameGender;
        if (sex === 'male' || sex === 'female') {
            nameGender = sex;
        }
        return {
            displayId: chance.hash({
                length: 8
            }),
            sex,
            firstName: chance.first({
                gender: nameGender
            }),
            middleName: chance.first({
                gender: nameGender
            }),
            lastName: chance.last(),
            culturalName: chance.first({
                gender: nameGender
            }),
            dateOfDeath: null,
            email: chance.email()
        };
    },
    PatientAdditionalData: ({ id, patientId })=>{
        const commonId = id || patientId || (0, _generateId.fakeUUID)();
        return {
            id: commonId,
            patientId: commonId,
            placeOfBirth: chance.city(),
            bloodType: chance.pickone([
                'O',
                'A',
                'B',
                'AB'
            ]) + chance.pickone([
                '+',
                '-'
            ]),
            primaryContactNumber: chance.phone(),
            secondaryContactNumber: chance.phone(),
            maritalStatus: chance.pickone([
                'Single',
                'Married',
                'Widowed',
                'Divorced',
                'Separated',
                'De Facto'
            ]),
            cityTown: chance.city(),
            streetVillage: chance.street(),
            educationalLevel: chance.pickone([
                'None',
                'Primary',
                'High School',
                'Bachelors',
                'Masters',
                'PhD.'
            ]),
            socialMedia: `@${chance.word()}`,
            title: chance.prefix(),
            birthCertificate: `BC${chance.natural({
                min: 1000000,
                max: 9999999
            })}`,
            drivingLicense: `L${chance.natural({
                min: 100000,
                max: 999999
            })}`,
            passport: chance.character() + chance.natural({
                min: 10000000,
                max: 99999999
            }).toString(),
            emergencyContactName: chance.name(),
            emergencyContactNumber: chance.phone(),
            secondaryVillageId: null,
            updatedAtByField: null
        };
    },
    PatientFacility: ({ patientId = (0, _generateId.fakeUUID)(), facilityId = (0, _generateId.fakeUUID)() })=>{
        return {
            id: `${patientId};${facilityId}`,
            patientId,
            facilityId
        };
    },
    PatientDeathData: ()=>{
        const options = [
            'yes',
            'no',
            'unknown',
            null
        ];
        return {
            wasPregnant: chance.pickone(options),
            pregnancyContributed: chance.pickone(options),
            recentSurgery: chance.pickone(options),
            stillborn: chance.pickone(options)
        };
    },
    PatientProgramRegistration: ()=>({
            registrationStatus: _constants.REGISTRATION_STATUSES.ACTIVE
        }),
    User: ()=>({
            email: chance.email(),
            displayId: chance.hash({
                length: 5
            }),
            displayName: chance.name(),
            role: 'practitioner'
        }),
    ReferenceData: ()=>({
            type: chance.pickone(_constants.REFERENCE_TYPE_VALUES)
        }),
    Role: ()=>({
            name: `${(0, _lodash.snakeCase)(chance.profession())}_${chance.hash({
                length: 8
            })}`
        }),
    Survey: ()=>({
            isSensitive: false,
            notifyEmailAddresses: []
        }),
    SurveyScreenComponent: ()=>({
            calculation: null,
            visibilityCriteria: null,
            config: null,
            options: null
        }),
    Encounter: ()=>({
            encounterType: chance.pickone(_constants.ENCOUNTER_TYPE_VALUES)
        }),
    Note: ()=>({
            // This is a hack because the type of Note.id is UUID, whereas tests might create ids of the form:
            // Note.id.123e4567-e89b-12d3-a456-426614174000
            // Setting id: undefined allows the model to create a default uuid and therefore avoid erroring
            // It will be fixed properly as part of EPI-160
            id: undefined,
            noteType: chance.pickone(_constants.NOTE_TYPE_VALUES),
            revisedById: undefined
        }),
    Location: ()=>({
            maxOccupancy: 1
        }),
    ProgramRegistry: ()=>({
            currentlyAtType: chance.pickone(Object.values(_constants.CURRENTLY_AT_TYPES))
        }),
    AppointmentSchedule: ()=>{
        const frequency = chance.pickone(_constants.REPEAT_FREQUENCY_VALUES);
        const endsMode = chance.pickone([
            'on',
            'after'
        ]);
        return {
            daysOfWeek: [
                chance.pickone(_constants.DAYS_OF_WEEK)
            ],
            nthWeekday: frequency === _constants.REPEAT_FREQUENCY.MONTHLY ? chance.integer({
                min: -1,
                max: 4
            }) : null,
            ...endsMode === 'on' ? {
                untilDate: fakeDateTimeString()
            } : {
                occurrenceCount: chance.integer({
                    min: 1,
                    max: 99
                })
            }
        };
    }
};
const FHIR_MODELS_HANDLERS = {
    FhirPatient: {
        identifier: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirIdentifier.fake(...args)),
        name: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirHumanName.fake(...args)),
        telecom: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirContactPoint.fake(...args)),
        address: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirAddress.fake(...args)),
        link: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirPatientLink.fake(...args)),
        extension: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirExtension.fake(...args))
    },
    FhirServiceRequest: {
        identifier: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirIdentifier.fake(...args)),
        category: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirCodeableConcept.fake(...args)),
        order_detail: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirCodeableConcept.fake(...args)),
        location_code: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirCodeableConcept.fake(...args)),
        code: (...args)=>_fhirTypes.FhirCodeableConcept.fake(...args),
        subject: (...args)=>_fhirTypes.FhirReference.fake(...args),
        requester: (...args)=>_fhirTypes.FhirReference.fake(...args)
    },
    FhirDiagnosticReport: {
        extension: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirExtension.fake(...args)),
        identifier: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirIdentifier.fake(...args)),
        code: (...args)=>_fhirTypes.FhirCodeableConcept.fake(...args),
        subject: (...args)=>_fhirTypes.FhirReference.fake(...args),
        performer: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirReference.fake(...args)),
        result: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirReference.fake(...args))
    },
    FhirImmunization: {
        vaccine_code: (...args)=>_fhirTypes.FhirCodeableConcept.fake(...args),
        patient: (...args)=>_fhirTypes.FhirReference.fake(...args),
        encounter: (...args)=>_fhirTypes.FhirReference.fake(...args),
        site: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirCodeableConcept.fake(...args)),
        performer: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirImmunizationPerformer.fake(...args)),
        protocol_applied: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirImmunizationProtocolApplied.fake(...args))
    },
    FhirImagingStudy: {
        identifier: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirIdentifier.fake(...args)),
        basedOn: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirReference.fake(...args)),
        note: (...args)=>Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>_fhirTypes.FhirAnnotation.fake(...args))
    }
};
const fake = (model, passedOverrides = {})=>{
    const id = (0, _generateId.fakeUUID)();
    const record = {};
    const modelOverridesFn = MODEL_SPECIFIC_OVERRIDES[model.name];
    const modelOverrides = modelOverridesFn ? modelOverridesFn(passedOverrides) : {};
    const overrides = {
        ...modelOverrides,
        ...passedOverrides
    };
    const overrideFields = Object.keys(overrides);
    function fakeField(name, attribute) {
        const { type, fieldName, defaultValue } = attribute;
        if (overrideFields.includes(fieldName)) {
            return overrides[fieldName];
        }
        if (attribute.references) {
            // null out id fields
            return null;
        }
        if (IGNORED_FIELDS.includes(fieldName)) {
            // ignore metadata fields
            return undefined;
        }
        if (fieldName === 'id') {
            return (0, _generateId.fakeUUID)();
        }
        if (fieldName === 'visibilityStatus') {
            return _constants.VISIBILITY_STATUSES.CURRENT;
        }
        if (type instanceof _sequelize.DataTypes.ARRAY && type.type) {
            return Array(chance.integer({
                min: 0,
                max: 3
            })).fill(0).map(()=>fakeField(name, {
                    ...attribute,
                    type: type.type
                }));
        }
        if (defaultValue) {
            if (defaultValue instanceof _sequelize.default.NOW || defaultValue instanceof _sequelize.default.UUIDV4) {
                return undefined;
            }
            return (0, _lodash.isFunction)(defaultValue) ? defaultValue() : defaultValue;
        }
        if (type instanceof _sequelize.DataTypes.BLOB) {
            return Buffer.from('test');
        }
        if (FIELD_HANDLERS[type]) {
            return FIELD_HANDLERS[type](model, attribute, id);
        }
        if (type.type && FIELD_HANDLERS[type.type]) {
            return FIELD_HANDLERS[type.type](model, attribute, id);
        }
        if (type instanceof _sequelize.DataTypes.STRING && type.options.length) {
            return FIELD_HANDLERS['VARCHAR(N)'](model, attribute, id, type.options.length);
        }
        if (type instanceof _sequelize.DataTypes.JSONB && FHIR_MODELS_HANDLERS[model.name]?.[fieldName]) {
            return FHIR_MODELS_HANDLERS[model.name][fieldName](model, attribute, id);
        }
        if (type instanceof _sequelize.DataTypes.JSONB) {
            return {
                test: 'test'
            };
        }
        // if you hit this error, you probably need to add a new field handler or a model-specific override
        throw new Error(`Could not fake field ${model.name}.${name} of type ${type} / ${type.type} / ${(0, _util.inspect)(type)}`);
    }
    for (const [name, attribute] of Object.entries(model.tableAttributes)){
        const fakeValue = fakeField(name, attribute);
        if (fakeValue !== undefined) record[name] = fakeValue;
    }
    return record;
};

//# sourceMappingURL=fake.js.map