"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "startScheduledTasks", {
    enumerable: true,
    get: function() {
        return startScheduledTasks;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _MedicationDiscontinuer = require("./MedicationDiscontinuer");
const _RefreshMaterializedView = require("./RefreshMaterializedView");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const DEFAULT_TASK_CLASSES = [
    _MedicationDiscontinuer.MedicationDiscontinuer,
    _RefreshMaterializedView.RefreshUpcomingVaccinations
];
function startScheduledTasks(context, taskClasses) {
    if (_config.default.senaite.enabled) {
    // TODO: port to new backend
    // const senaite = new SenaitePoller(context);
    // senaite.beginPolling();
    }
    const tasks = (taskClasses || DEFAULT_TASK_CLASSES).map((Task)=>new Task(context));
    tasks.forEach((t)=>t.beginPolling());
    return ()=>tasks.forEach((t)=>t.cancelPolling());
}

//# sourceMappingURL=index.js.map