import { DataSection } from './DataSection';
import { Col } from '../Layout';
import { DataItem } from './DataItem';
import React from 'react';
import { formatShort } from '@tamanu/utils/dateTime';
import { useLanguageContext } from '../../pdf/languageContext';
export const EncounterDetailsExtended = ({ encounter, discharge })=>{
    const { location, examiner, department, startDate, endDate, reasonForEncounter } = encounter;
    const { getTranslation } = useLanguageContext();
    const clinicianText = getTranslation('general.localisedField.clinician.label.short', 'Clinician', null, false, true);
    return /*#__PURE__*/ React.createElement(DataSection, {
        title: getTranslation('pdf.encounterDetails.title', 'Encounter details'),
        hideBottomRule: true
    }, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.localisedField.facility.label', 'Facility'),
        value: location.facility.name,
        key: "facility"
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.supervisingClinician.label', 'Supervising :clinician', {
            clinician: clinicianText
        }),
        value: examiner.displayName,
        key: "supervisingClinician"
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.dischargingClinician.label', 'Discharging :clinician', {
            clinician: clinicianText
        }),
        value: discharge?.discharger?.displayName,
        key: "dischargingClinician"
    }), discharge?.disposition?.name && /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.localisedField.dischargeDisposition.label', 'Discharge disposition'),
        value: discharge?.disposition?.name,
        key: "dischargeDisposition"
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.department.label', 'Department'),
        value: department.name,
        key: "department"
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('encounter.dateOfAdmission.label', 'Date of admission'),
        value: formatShort(startDate),
        key: "dateOfAdmission"
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('encounter.dateOfDischarge.label', 'Date of discharge'),
        value: discharge ? formatShort(endDate) : getTranslation('general.encounterDischargedNotApplicable', 'n/a (encounter in progress)'),
        key: "dateOfDischarge"
    })), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('encounter.reasonForEncounter.label', 'Reason for encounter'),
        value: reasonForEncounter,
        key: "reasonForEncounter"
    }));
};

//# sourceMappingURL=EncounterDetailsExtended.js.map