"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    userInfo: function() {
        return userInfo;
    },
    userMiddleware: function() {
        return userMiddleware;
    }
});
const _api = require("@opentelemetry/api");
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _auth = require("@tamanu/constants/auth");
const _logging = require("@tamanu/shared/services/logging");
const _errors = require("@tamanu/shared/errors");
const _utils = require("./utils");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const userMiddleware = ({ secret })=>(0, _expressasynchandler.default)(async (req, res, next)=>{
        const { store, headers } = req;
        const { canonicalHostName } = _config.default;
        // get token
        const { authorization } = headers;
        if (!authorization) {
            throw new _errors.ForbiddenError();
        }
        // verify token
        const [bearer, token] = authorization.split(/\s/);
        if (bearer.toLowerCase() !== 'bearer') {
            throw new _errors.BadAuthenticationError('Only Bearer token is supported');
        }
        let contents = null;
        try {
            contents = await (0, _utils.verifyToken)(token, secret, {
                issuer: canonicalHostName,
                audience: _auth.JWT_TOKEN_TYPES.ACCESS
            });
        } catch (e) {
            const errorMessage = 'Auth error: Invalid token (hG7c)';
            _logging.log.debug(errorMessage, {
                error: e.message
            });
            res.status(401).send({
                error: {
                    message: errorMessage
                }
            });
            return;
        }
        const { userId, deviceId } = contents;
        const user = await (0, _utils.findUserById)(store.models, userId);
        if (!user) {
            throw new _errors.BadAuthenticationError(`User specified in token (${userId}) does not exist`);
        }
        /* eslint-disable require-atomic-updates */ // in this case we don't care if we're overwriting the user/deviceId
        // and express also guarantees execution order for middlewares
        req.user = user;
        req.deviceId = deviceId;
        /* eslint-enable require-atomic-updates */ const spanAttributes = user ? {
            'app.user.id': user.id,
            'app.user.role': user.role
        } : {};
        // eslint-disable-next-line no-unused-expressions
        _api.trace.getActiveSpan()?.setAttributes(spanAttributes);
        _api.context.with(_api.propagation.setBaggage(_api.context.active(), _api.propagation.createBaggage(spanAttributes)), ()=>next());
    });
const userInfo = (0, _expressasynchandler.default)(async (req, res)=>{
    if (!req.user) {
        throw new _errors.ForbiddenError();
    }
    res.send((0, _utils.stripUser)(req.user));
});

//# sourceMappingURL=userMiddleware.js.map