"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ProgramRegistry", {
    enumerable: true,
    get: function() {
        return ProgramRegistry;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _errors = require("@tamanu/shared/errors");
const _Model = require("./Model");
let ProgramRegistry = class ProgramRegistry extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false,
                unique: true
            },
            name: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            currentlyAtType: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            validate: {
                mustHaveValidCurrentlyAtType () {
                    const values = Object.values(_constants.CURRENTLY_AT_TYPES);
                    if (!values.includes(this.currentlyAtType)) {
                        throw new _errors.InvalidOperationError(`The currentlyAtType must be one of ${values.join(', ')}`);
                    }
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Program, {
            foreignKey: 'programId',
            as: 'program'
        });
        this.hasMany(models.ProgramRegistryClinicalStatus, {
            foreignKey: 'programRegistryId',
            as: 'clinicalStatuses'
        });
        this.hasMany(models.PatientProgramRegistration, {
            foreignKey: 'programRegistryId',
            as: 'patientProgramRegistrations'
        });
        this.hasMany(models.PatientProgramRegistrationCondition, {
            foreignKey: 'programRegistryId',
            as: 'patientProgramRegistrationConditions'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ProgramRegistry.js.map