import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class EncounterMedication extends Model {
    id: string;
    date: string;
    endDate?: string;
    prescription?: string;
    note?: string;
    indication?: string;
    route?: string;
    qtyMorning?: number;
    qtyLunch?: number;
    qtyEvening?: number;
    qtyNight?: number;
    quantity?: number;
    discontinued?: boolean;
    discontinuedDate?: string;
    discontinuingReason?: string;
    repeats?: number;
    isDischarge: boolean;
    prescriberId?: string;
    discontinuingClinicianId?: string;
    encounterId?: string;
    medicationId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getListReferenceAssociations(): string[];
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): {
        select: string;
        joins: string;
    };
}
//# sourceMappingURL=EncounterMedication.d.ts.map