"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    MAX_CLIENT_VERSION: function() {
        return MAX_CLIENT_VERSION;
    },
    MIN_CLIENT_VERSION: function() {
        return MIN_CLIENT_VERSION;
    },
    VERSION: function() {
        return VERSION;
    },
    versionCompatibility: function() {
        return versionCompatibility;
    }
});
const _fs = require("fs");
const _path = require("path");
const _url = require("url");
const _semver = require("semver");
const _utils = require("@tamanu/shared/utils");
const pkgpath = (0, _path.join)((0, _path.dirname)((0, _url.fileURLToPath)(require("url").pathToFileURL(__filename).toString())), '../../package.json');
const pkgjson = JSON.parse((0, _fs.readFileSync)(pkgpath, 'utf8'));
const { major, minor } = (0, _semver.parse)(pkgjson.version);
const VERSION = pkgjson.version;
// In general, all versions in the current minor version should be compatible with each other.
// However, if there is an incompatibility between the web client version and a facility server
// version, this can be used to override the forbid clients below a certain version from connecting.
//
// To do so, set this to a string like '1.30.2'.
//
// THIS SHOULD BE RARE and only used in exceptional circumstances.
// When merging to main or other branches, this MUST be reset to null.
const MIN_CLIENT_OVERRIDE = null;
const MIN_CLIENT_VERSION = MIN_CLIENT_OVERRIDE ?? `${major}.${minor}.0`;
const MAX_CLIENT_VERSION = `${major}.${minor}.999`;
const versionCompatibility = (req, res, next)=>(0, _utils.buildVersionCompatibilityCheck)(MIN_CLIENT_VERSION, MAX_CLIENT_VERSION)(req, res, next);

//# sourceMappingURL=versionCompatibility.js.map