"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    CertificateAddress: function() {
        return CertificateAddress;
    },
    CertificateSubtitle: function() {
        return CertificateSubtitle;
    },
    CertificateTitle: function() {
        return CertificateTitle;
    },
    H1: function() {
        return H1;
    },
    H2: function() {
        return H2;
    },
    H3: function() {
        return H3;
    },
    P: function() {
        return P;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _Text = require("../pdf/Text");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const styles = _renderer.StyleSheet.create({
    h1: {
        fontFamily: 'Helvetica-Bold',
        textAlign: 'center',
        marginTop: 10,
        marginBottom: 10,
        fontSize: 15,
        fontWeight: 700
    },
    h2: {
        fontFamily: 'Helvetica-Bold',
        textAlign: 'center',
        fontSize: 14,
        marginBottom: 30,
        fontWeight: 500
    },
    h3: {
        fontFamily: 'Helvetica-Bold',
        marginBottom: 20,
        fontSize: 14,
        fontWeight: 500
    },
    p: {
        fontFamily: 'Helvetica',
        fontSize: 12,
        fontWeight: 400,
        marginBottom: 15
    },
    certificateAddress: {
        fontFamily: 'Helvetica-Bold',
        textAlign: 'right',
        fontSize: 14,
        marginBottom: 13
    },
    certificateTitle: {
        fontFamily: 'Helvetica-Bold',
        fontSize: 18,
        textAlign: 'right',
        marginBottom: 14
    },
    certificateSubtitle: {
        fontFamily: 'Helvetica',
        fontSize: 18,
        textAlign: 'right',
        marginTop: '-10px',
        height: 40
    }
});
const H1 = ({ style, ...props })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: {
            ...styles.h1,
            ...style
        },
        ...props
    });
const H2 = ({ style, ...props })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: {
            ...styles.h2,
            ...style
        },
        ...props
    });
const H3 = ({ style, ...props })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: {
            ...styles.h3,
            ...style
        },
        ...props
    });
const P = ({ mt = 0, mb, bold = false, fontSize = 14, style = {}, ...props })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        ...props,
        style: [
            styles.p,
            {
                marginTop: mt,
                marginBottom: mb,
                fontSize
            },
            style
        ],
        bold: bold
    });
const CertificateAddress = (props)=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: styles.certificateAddress,
        ...props
    });
const CertificateTitle = (props)=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: styles.certificateTitle,
        ...props
    });
const CertificateSubtitle = (props)=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: styles.certificateSubtitle,
        ...props
    });

//# sourceMappingURL=Typography.js.map