"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "CovidPatientDetailsSection", {
    enumerable: true,
    get: function() {
        return CovidPatientDetailsSection;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _Layout = require("./Layout");
const _Typography = require("./Typography");
const _patientAccessors = require("../patientAccessors");
const _languageContext = require("../pdf/languageContext");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const PATIENT_FIELDS = [
    {
        key: 'firstName',
        label: 'First name'
    },
    {
        key: 'lastName',
        label: 'Last name'
    },
    {
        key: 'dateOfBirth',
        label: 'Date of birth',
        accessor: _patientAccessors.getDob
    },
    {
        key: 'sex',
        label: 'Sex'
    },
    {
        key: 'displayId',
        label: 'NHN'
    },
    {
        key: 'passport',
        label: 'Passport number',
        accessor: _patientAccessors.getPassportNumber
    },
    {
        key: 'nationality',
        label: 'Nationality',
        accessor: _patientAccessors.getNationality
    }
];
const CovidPatientDetailsSection = ({ patient, getLocalisation, getSetting, vdsSrc, extraFields = [], uvci })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    const detailsToDisplay = [
        ...PATIENT_FIELDS,
        ...extraFields
    ].filter(({ key })=>!getSetting(`fields.${key}.hidden`));
    const leftWidth = vdsSrc ? 68 : 80;
    const rightWidth = 100 - leftWidth;
    return /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, {
        style: {
            width: `${leftWidth}%`
        }
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, detailsToDisplay.map(({ key, label: defaultLabel, accessor })=>{
        const value = accessor?.(patient, {
            getLocalisation,
            getTranslation
        }) ?? (patient[key] || '');
        const label = getTranslation(`general.localisedFields.${key}.label.short`) || getTranslation(`general.localisedFields.${key}.label`) || defaultLabel;
        return /*#__PURE__*/ _react.default.createElement(_Layout.Col, {
            key: key
        }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
            mb: 5
        }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
            bold: true
        }, label, ":"), " ", value));
    })), uvci && /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        bold: true
    }, "UVCI:"), " ", uvci))), /*#__PURE__*/ _react.default.createElement(_Layout.Col, {
        style: {
            width: `${rightWidth}%`
        }
    }, vdsSrc && /*#__PURE__*/ _react.default.createElement(_Layout.VDSImage, {
        src: vdsSrc
    })));
};

//# sourceMappingURL=CovidPatientDetailsSection.js.map