"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createApp", {
    enumerable: true,
    get: function() {
        return createApp;
    }
});
const _dbNotifier = require("@tamanu/shared/services/dbNotifier");
const _constants = require("@tamanu/constants");
const _createApi = require("./createApi");
const _createWebsocket = require("./createWebsocket");
const _sync = require("./sync");
async function createApp(ctx) {
    const api = await (0, _createApi.createApi)(ctx);
    const dbNotifier = await (0, _dbNotifier.defineDbNotifier)(ctx.store.sequelize.config, [
        _constants.NOTIFY_CHANNELS.TABLE_CHANGED
    ]);
    await (0, _sync.registerSyncLookupUpdateListener)(ctx.store.models, dbNotifier);
    const websocket = await (0, _createWebsocket.createWebsocket)(api.httpServer, ctx);
    // Release the connection back to the pool when the server is closed
    api.httpServer.on('close', ()=>{
        dbNotifier.close();
    });
    return {
        express: api.express,
        server: api.httpServer,
        websocket
    };
}

//# sourceMappingURL=createApp.js.map