"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    camelify: function() {
        return camelify;
    },
    deepRenameObjectKeys: function() {
        return deepRenameObjectKeys;
    },
    renameObjectKeys: function() {
        return renameObjectKeys;
    }
});
const _lodash = require("lodash");
const camelify = (str)=>{
    const [initial, ...subsequent] = str.split('_');
    const uppercased = subsequent.filter((x)=>x).map((s)=>s[0]?.toUpperCase() + s.slice(1));
    return [
        initial,
        ...uppercased
    ].join('');
};
const renameObjectKeys = (baseObject)=>{
    return Object.keys(baseObject).reduce((rebuilt, currentKey)=>({
            ...rebuilt,
            [camelify(currentKey)]: baseObject[currentKey]
        }), {});
};
const deepRenameObjectKeys = (baseObject)=>{
    if (!(0, _lodash.isPlainObject)(baseObject)) return baseObject;
    return Object.keys(baseObject).reduce((rebuilt, currentKey)=>({
            ...rebuilt,
            [camelify(currentKey)]: typeof baseObject[currentKey] === 'object' && baseObject[currentKey] !== null ? deepRenameObjectKeys(baseObject[currentKey]) : baseObject[currentKey]
        }), {});
};

//# sourceMappingURL=renameObjectKeys.js.map