"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientCommunication", {
    enumerable: true,
    get: function() {
        return PatientCommunication;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let PatientCommunication = class PatientCommunication extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            type: {
                type: _sequelize.DataTypes.ENUM(..._constants.PATIENT_COMMUNICATION_TYPES_VALUES),
                allowNull: false
            },
            channel: {
                type: _sequelize.DataTypes.ENUM(..._constants.PATIENT_COMMUNICATION_CHANNELS_VALUES),
                allowNull: false
            },
            subject: _sequelize.DataTypes.TEXT,
            content: _sequelize.DataTypes.TEXT,
            status: {
                type: _sequelize.DataTypes.ENUM(..._constants.COMMUNICATION_STATUSES_VALUES),
                allowNull: false,
                defaultValue: _constants.COMMUNICATION_STATUSES.QUEUED
            },
            error: _sequelize.DataTypes.TEXT,
            retryCount: _sequelize.DataTypes.INTEGER,
            destination: _sequelize.DataTypes.STRING,
            attachment: _sequelize.DataTypes.STRING,
            hash: _sequelize.DataTypes.INTEGER
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PUSH_TO_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
    }
    static getBaseQueryPendingMessage(channel) {
        const threshold = _config.default.patientCommunication?.retryThreshold;
        return {
            where: {
                status: _constants.COMMUNICATION_STATUSES.QUEUED,
                channel,
                [_sequelize.Op.or]: [
                    {
                        retryCount: {
                            [_sequelize.Op.lte]: threshold
                        }
                    },
                    {
                        retryCount: null
                    }
                ]
            }
        };
    }
    static getPendingMessages(channel, queryOptions) {
        return this.findAll({
            ...this.getBaseQueryPendingMessage(channel),
            order: [
                [
                    this.sequelize.literal('retry_count IS NULL'),
                    'DESC'
                ],
                [
                    'retryCount',
                    'ASC'
                ],
                [
                    'createdAt',
                    'ASC'
                ]
            ],
            ...queryOptions
        });
    }
    static countPendingMessages(channel) {
        return this.count(this.getBaseQueryPendingMessage(channel));
    }
};

//# sourceMappingURL=PatientCommunication.js.map