"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "generateImportData", {
    enumerable: true,
    get: function() {
        return generateImportData;
    }
});
const _fake = require("../../fake");
const generateImportData = async ({ ReferenceData, ReferenceDataRelation, Facility, LocationGroup, Location, Department, Survey, SurveyScreenComponent, ScheduledVaccine, ProgramDataElement, Program, ProgramRegistry, ProgramRegistryCondition, ProgramRegistryClinicalStatus, InvoiceProduct, LabTestType, User })=>{
    const referenceData = await ReferenceData.create((0, _fake.fake)(ReferenceData));
    await ReferenceDataRelation.create((0, _fake.fake)(ReferenceDataRelation));
    const facility = await Facility.create((0, _fake.fake)(Facility));
    const locationGroup = await LocationGroup.create((0, _fake.fake)(LocationGroup, {
        facilityId: facility.id
    }));
    const location = await Location.create((0, _fake.fake)(Location, {
        facilityId: facility.id,
        locationGroupId: locationGroup.id
    }));
    const department = await Department.create((0, _fake.fake)(Department, {
        facilityId: facility.id
    }));
    const survey = await Survey.create((0, _fake.fake)(Survey));
    await SurveyScreenComponent.create((0, _fake.fake)(SurveyScreenComponent, {
        surveyId: survey.id,
        option: '{"foo":"bar"}',
        config: '{"source": "ReferenceData", "where": {"type": "facility"}}'
    }));
    const scheduledVaccine = await ScheduledVaccine.create((0, _fake.fake)(ScheduledVaccine, {
        vaccineId: referenceData.id
    }));
    await ProgramDataElement.create((0, _fake.fake)(ProgramDataElement));
    const program = await Program.create((0, _fake.fake)(Program));
    const programRegistry = await ProgramRegistry.create((0, _fake.fake)(ProgramRegistry, {
        programId: program.id
    }));
    await ProgramRegistryCondition.create((0, _fake.fake)(ProgramRegistryCondition, {
        programRegistryId: programRegistry.id
    }));
    await ProgramRegistryClinicalStatus.create((0, _fake.fake)(ProgramRegistryClinicalStatus, {
        programRegistryId: programRegistry.id
    }));
    const invoiceProduct = await InvoiceProduct.create((0, _fake.fake)(InvoiceProduct, {
        id: referenceData.id
    }));
    const labTestType = await LabTestType.create((0, _fake.fake)(LabTestType, {
        labTestCategoryId: referenceData.id
    }));
    const user = await User.create((0, _fake.fake)(User));
    return {
        referenceData,
        facility,
        department,
        locationGroup,
        location,
        survey,
        scheduledVaccine,
        invoiceProduct,
        labTestType,
        user,
        programRegistry
    };
};

//# sourceMappingURL=importData.js.map