"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createTask", {
    enumerable: true,
    get: function() {
        return createTask;
    }
});
const _fake = require("../../fake");
const createTask = async ({ models, encounterId, userId, referenceDataId })=>{
    const { Task, TaskDesignation, TaskTemplate, TaskTemplateDesignation, UserDesignation } = models;
    const task = await Task.create((0, _fake.fake)(Task, {
        encounterId,
        requestedByUserId: userId,
        completedByUserId: userId,
        notCompletedByUserId: userId,
        notCompletedReasonId: referenceDataId,
        todoByUserId: userId,
        deletedByUserId: userId,
        deletedReasonId: referenceDataId
    }));
    await TaskDesignation.create((0, _fake.fake)(TaskDesignation, {
        taskId: task.id,
        designationId: referenceDataId
    }));
    const taskTemplate = await TaskTemplate.create((0, _fake.fake)(TaskTemplate, {
        referenceDataId
    }));
    await TaskTemplateDesignation.create((0, _fake.fake)(TaskTemplateDesignation, {
        taskTemplateId: taskTemplate.id,
        designationId: referenceDataId
    }));
    await UserDesignation.create((0, _fake.fake)(UserDesignation, {
        userId,
        designationId: referenceDataId
    }));
};

//# sourceMappingURL=tasking.js.map