"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    populateDbFromTallyFile: function() {
        return populateDbFromTallyFile;
    },
    readJSON: function() {
        return readJSON;
    }
});
const _lodash = require("lodash");
const _fs = require("fs");
const _helpers = require("../helpers");
// TODO: this needs way more data groups
const MODEL_TO_FUNCTION = {
    Appointment: {
        POST: _helpers.createRepeatingAppointment,
        PUT: ()=>null
    },
    Patient: {
        POST: _helpers.createPatient,
        PUT: ()=>null
    },
    Encounter: {
        POST: _helpers.createEncounter,
        PUT: ()=>null
    },
    ImagingRequest: {
        POST: _helpers.createImagingRequest,
        PUT: ()=>null
    },
    Invoice: {
        POST: _helpers.createInvoice,
        PUT: ()=>null
    },
    LabRequest: {
        createLabRequest: _helpers.createLabRequest,
        PUT: ()=>null
    },
    ProgramRegistry: {
        POST: _helpers.createProgramRegistry,
        PUT: ()=>null
    },
    Survey: {
        POST: _helpers.createSurveyResponse,
        PUT: ()=>null
    },
    Tasking: {
        POST: _helpers.createTask,
        PUT: ()=>null
    },
    Vaccine: {
        POST: _helpers.createAdministeredVaccine,
        PUT: ()=>null
    },
    ReportDefinition: {
        POST: _helpers.createDbReport,
        PUT: ()=>null
    }
};
const readJSON = async (path)=>{
    const data = await _fs.promises.readFile(path, 'utf8');
    return JSON.parse(data);
};
const populateDbFromTallyFile = async (tallyFilePath, models)=>{
    await (0, _helpers.generateImportData)(models);
    const tallyJson = await readJSON(tallyFilePath);
    Object.entries(tallyJson).forEach(([model, tally])=>{
        const { POST: postCount, PUT: putCount } = tally;
        const { POST: simulatePost, PUT: simplatePut } = MODEL_TO_FUNCTION[model];
        (0, _lodash.times)(postCount, async ()=>simulatePost({
                models
            }));
        (0, _lodash.times)(putCount, async ()=>simplatePut({
                models
            }));
    });
};

//# sourceMappingURL=populateFromLogTally.js.map