import { StyleSheet, View } from '@react-pdf/renderer';
import React from 'react';
import { formatShort, formatTime, getCurrentDateTimeString } from '@tamanu/utils/dateTime';
import { Text } from '../../pdf/Text';
import { useLanguageContext } from '../../pdf/languageContext';
const styles = StyleSheet.create({
    footer: {
        position: 'absolute',
        flexDirection: 'row',
        justifyContent: 'space-between',
        bottom: 25,
        left: 50,
        right: 50,
        color: '#888888',
        borderTop: '1px solid #888888',
        paddingTop: 2
    },
    footerLeftContent: {
        flexDirection: 'row',
        flexWrap: 'wrap'
    },
    footerRightContent: {
        flexDirection: 'row',
        textAlign: 'right'
    },
    labelText: {
        fontSize: 8,
        fontWeight: 400,
        fontFamily: 'Helvetica-Bold'
    },
    valueText: {
        fontSize: 8,
        fontWeight: 400,
        fontFamily: 'Helvetica'
    }
});
const LabelText = ({ children, ...props })=>/*#__PURE__*/ React.createElement(Text, {
        style: styles.labelText,
        ...props
    }, children);
const ValueText = ({ children, ...props })=>/*#__PURE__*/ React.createElement(Text, {
        style: styles.valueText,
        ...props
    }, children);
export const Footer = ({ printDate, printFacility, printedBy, style })=>{
    const { getTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(View, {
        style: [
            styles.footer,
            style
        ],
        fixed: true
    }, /*#__PURE__*/ React.createElement(View, {
        style: styles.footerLeftContent
    }, /*#__PURE__*/ React.createElement(LabelText, null, getTranslation('pdf.footer.printDateAndTime.label', 'Print date & time'), ":", ' '), /*#__PURE__*/ React.createElement(ValueText, null, formatShort(printDate || getCurrentDateTimeString()), ' ', formatTime(printDate || getCurrentDateTimeString())), printFacility && /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(ValueText, null, " |"), /*#__PURE__*/ React.createElement(LabelText, null, getTranslation('pdf.footer.printFacility.label', 'Print facility'), ":", ' '), /*#__PURE__*/ React.createElement(ValueText, null, printFacility, " ")), printedBy && /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(ValueText, null, " |"), /*#__PURE__*/ React.createElement(LabelText, null, getTranslation('pdf.footer.printedBy.label', 'Printed by'), ":"), ' ', /*#__PURE__*/ React.createElement(ValueText, null, printedBy))), /*#__PURE__*/ React.createElement(View, {
        style: styles.footerRightContent
    }, /*#__PURE__*/ React.createElement(Text, {
        style: styles.valueText,
        render: ({ pageNumber, totalPages })=>getTranslation('pdf.pagination', ':currentPage of :totalPages', {
                replacements: {
                    currentPage: pageNumber,
                    totalPages
                }
            })
    })));
};

//# sourceMappingURL=Footer.js.map