"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SyncDeviceTick", {
    enumerable: true,
    get: function() {
        return SyncDeviceTick;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let SyncDeviceTick = class SyncDeviceTick extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: {
                // Sequelize always requires an id column
                // so this is to enforce using persisted_at_sync_tick as the id.
                // even tho we don't really need an id in this table.
                // We don't use the value of persisted_at_sync_tick in id
                // just so that it is clear about the type of tick that it is storing.
                type: `BIGINT GENERATED ALWAYS AS ("persisted_at_sync_tick")`,
                set () {
                // any sets of the convenience generated "id" field can be ignored, so do nothing here
                }
            },
            persistedAtSyncTick: {
                type: _sequelize.DataTypes.BIGINT,
                primaryKey: !!primaryKey
            },
            deviceId: {
                type: _sequelize.DataTypes.TEXT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC,
            timestamps: false
        });
    }
};

//# sourceMappingURL=SyncDeviceTick.js.map