import { Model } from './Model';
import { type InitOptions } from '../types/model';
export declare class SyncSession extends Model {
    id: string;
    startTime?: Date;
    lastConnectionTime?: Date;
    snapshotStartedAt?: Date;
    snapshotCompletedAt?: Date;
    persistCompletedAt?: Date;
    completedAt?: Date;
    startedAtTick?: number;
    pullSince?: number;
    pullUntil?: number;
    errors?: string;
    debugInfo?: Record<string, object>;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static addDebugInfo(id: string, info: object): Promise<void>;
    /**
     * @param {number} tick sync tick
     */
    markAsStartedAt(tick: number): Promise<[affectedCount: number]>;
    markErrored(error: string): Promise<void>;
    static markSessionErrored(id: string, error: string): Promise<void>;
}
//# sourceMappingURL=SyncSession.d.ts.map