import * as yup from 'yup';
export declare const globalSettings: {
    title: string;
    description: string;
    properties: {
        auth: {
            highRisk: boolean;
            description: string;
            properties: {
                restrictUsersToFacilities: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                restrictUsersToSync: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
            };
        };
        ageDisplayFormat: {
            description: string;
            type: yup.ArraySchema<{
                as?: "years" | "months" | "days" | "weeks";
                range?: {
                    min?: {
                        duration?: {
                            years?: number;
                            months?: number;
                            days?: number;
                        };
                        exclusive?: boolean;
                    };
                    max?: {
                        duration?: {
                            years?: number;
                            months?: number;
                            days?: number;
                        };
                        exclusive?: boolean;
                    };
                };
            }[], yup.AnyObject, undefined, "">;
            defaultValue: ({
                as: string;
                range: {
                    min: {
                        duration: {
                            days: number;
                            months?: undefined;
                            years?: undefined;
                        };
                        exclusive: boolean;
                    };
                    max: {
                        duration: {
                            days: number;
                            months?: undefined;
                            years?: undefined;
                        };
                        exclusive: boolean;
                    };
                };
            } | {
                as: string;
                range: {
                    min: {
                        duration: {
                            days: number;
                            months?: undefined;
                            years?: undefined;
                        };
                        exclusive?: undefined;
                    };
                    max: {
                        duration: {
                            months: number;
                            days?: undefined;
                            years?: undefined;
                        };
                        exclusive: boolean;
                    };
                };
            } | {
                as: string;
                range: {
                    min: {
                        duration: {
                            months: number;
                            days?: undefined;
                            years?: undefined;
                        };
                        exclusive?: undefined;
                    };
                    max: {
                        duration: {
                            years: number;
                            days?: undefined;
                            months?: undefined;
                        };
                        exclusive: boolean;
                    };
                };
            } | {
                as: string;
                range: {
                    min: {
                        duration: {
                            years: number;
                            days?: undefined;
                            months?: undefined;
                        };
                        exclusive?: undefined;
                    };
                    max?: undefined;
                };
            })[];
        };
        appointments: {
            description: string;
            properties: {
                maxRepeatingAppointmentsPerGeneration: {
                    description: string;
                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                    defaultValue: number;
                };
            };
        };
        features: {
            description: string;
            properties: {
                mandateSpecimenType: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                enableAppointmentsExtentions: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                enableVaccineConsent: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                filterDischargeDispositions: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                editPatientDetailsOnMobile: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                quickPatientGenerator: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                enableInvoicing: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                enableTasking: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                registerNewPatient: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                hideOtherSex: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                enablePatientDeaths: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                enableNoteBackdating: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                enableCovidClearanceCertificate: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                editPatientDisplayId: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                enablePatientInsurer: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                patientPlannedMove: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                onlyAllowLabPanels: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                displayProcedureCodesInDischargeSummary: {
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                displayIcd10CodesInDischargeSummary: {
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                mandatoryVitalEditReason: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                enableVitalEdit: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                reminderContactModule: {
                    properties: {
                        enabled: {
                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                            defaultValue: boolean;
                        };
                    };
                };
                desktopCharting: {
                    properties: {
                        enabled: {
                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                            defaultValue: boolean;
                        };
                    };
                };
                idleTimeout: {
                    description: string;
                    properties: {
                        enabled: {
                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                            defaultValue: boolean;
                        };
                        timeoutDuration: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                        warningPromptDuration: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                        refreshInterval: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                    };
                };
                tableAutoRefresh: {
                    description: string;
                    properties: {
                        enabled: {
                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                            defaultValue: boolean;
                            unit: string;
                        };
                        interval: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                    };
                };
                disableInputPasting: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                discharge: {
                    description: string;
                    properties: {
                        dischargeNoteMandatory: {
                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                            defaultValue: boolean;
                            unit: string;
                        };
                        dischargeDiagnosisMandatory: {
                            description: string;
                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                            defaultValue: boolean;
                        };
                    };
                };
            };
        };
        customisations: {
            name: string;
            description: string;
            properties: {
                componentVersions: {
                    description: string;
                    type: yup.ObjectSchema<{}, yup.AnyObject, {}, "">;
                    defaultValue: {};
                };
            };
        };
        fhir: {
            name: string;
            description: string;
            properties: {
                worker: {
                    name: string;
                    description: string;
                    properties: {
                        heartbeat: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        assumeDroppedAfter: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
        fields: {
            name: string;
            description: string;
            properties: {
                emergencyContactName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                emergencyContactNumber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                displayId: {
                    name: string;
                    description: string;
                    properties: {
                        pattern: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
                firstName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                middleName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                lastName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                culturalName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                sex: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                email: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dateOfBirth: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                bloodType: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                title: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                placeOfBirth: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                countryOfBirthId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                maritalStatus: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                primaryContactNumber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                secondaryContactNumber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                socialMedia: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                settlementId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                streetVillage: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                cityTown: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                subdivisionId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                divisionId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                countryId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                medicalAreaId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                nursingZoneId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                nationalityId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                ethnicityId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                occupationId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                educationalLevel: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                villageName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                villageId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthCertificate: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                insurerId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                insurerPolicyNumber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                drivingLicense: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                passport: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                religionId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                patientBillingTypeId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                motherId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                fatherId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthWeight: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthLength: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthDeliveryType: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                gestationalAgeEstimate: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                apgarScoreOneMinute: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                apgarScoreFiveMinutes: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                apgarScoreTenMinutes: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                timeOfBirth: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                attendantAtBirth: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                nameOfAttendantAtBirth: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthType: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthFacilityId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                healthCenterId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                registeredBirthPlace: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                referralSourceId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                arrivalModeId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                prescriber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                prescriberId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                facility: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dischargeDisposition: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                notGivenReasonId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                markedForSync: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dateOfBirthFrom: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dateOfBirthTo: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dateOfBirthExact: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dateOfDeath: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                age: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                clinician: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                diagnosis: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                locationId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                locationGroupId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                circumstanceId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                date: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                registeredBy: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                status: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                conditions: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                programRegistry: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                reminderContactName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                reminderContactNumber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
            };
        };
        integrations: {
            name: string;
            description: string;
            properties: {
                imaging: {
                    description: string;
                    properties: {
                        enabled: {
                            description: string;
                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                            defaultValue: boolean;
                        };
                        provider: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
        invoice: {
            properties: {
                slidingFeeScale: {
                    name: string;
                    description: string;
                    type: yup.ArraySchema<number[][], yup.AnyObject, undefined, "">;
                    defaultValue: number[][];
                };
            };
        };
        imagingCancellationReasons: {
            description: string;
            type: yup.ArraySchema<{
                label?: string;
                value?: string;
                hidden?: boolean;
            }[], yup.AnyObject, undefined, "">;
            defaultValue: {
                value: string;
                label: string;
                hidden: boolean;
            }[];
        };
        imagingPriorities: {
            name: string;
            description: string;
            type: yup.ArraySchema<{
                label?: string;
                value?: string;
            }[], yup.AnyObject, undefined, "">;
            defaultValue: {
                value: string;
                label: string;
            }[];
        };
        labsCancellationReasons: {
            description: string;
            type: yup.ArraySchema<{
                label?: string;
                value?: string;
            }[], yup.AnyObject, undefined, "">;
            defaultValue: {
                value: string;
                label: string;
            }[];
        };
        printMeasures: {
            description: string;
            properties: {
                labRequestPrintLabel: {
                    description: string;
                    properties: {
                        width: {
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                        };
                    };
                };
                stickerLabelPage: {
                    description: string;
                    properties: {
                        pageWidth: {
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                        pageHeight: {
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                        pageMarginTop: {
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                        pageMarginLeft: {
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                        columnWidth: {
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                        columnGap: {
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                        rowHeight: {
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                        rowGap: {
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                    };
                };
                idCardPage: {
                    description: string;
                    properties: {
                        cardMarginTop: {
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                        cardMarginLeft: {
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                            unit: string;
                        };
                    };
                };
            };
        };
        layouts: {
            description: string;
            properties: {
                mobilePatientModules: {
                    description: string;
                    properties: {
                        programRegistries: {
                            description: string;
                            properties: {
                                hidden: {
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        diagnosisAndTreatment: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        vitals: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        programs: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        referral: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        vaccine: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        tests: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                    };
                };
                patientTabs: {
                    description: string;
                    properties: {
                        summary: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                            };
                        };
                        details: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                            };
                        };
                        results: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        referrals: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        programs: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        documents: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        vaccines: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        medication: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        invoices: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                    };
                };
                sidebar: {
                    description: string;
                    properties: {
                        dashboard: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        patients: {
                            description: string;
                            properties: {
                                patientsInpatients: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                patientsEmergency: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                patientsOutpatients: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        scheduling: {
                            description: string;
                            properties: {
                                schedulingOutpatients: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                schedulingLocations: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        medication: {
                            description: string;
                            properties: {
                                medicationAll: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        imaging: {
                            description: string;
                            properties: {
                                imagingActive: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                imagingCompleted: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        labs: {
                            description: string;
                            properties: {
                                labsAll: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                labsPublished: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        immunisations: {
                            description: string;
                            properties: {
                                immunisationsAll: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        facilityAdmin: {
                            description: string;
                            properties: {
                                reports: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                bedManagement: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                    };
                };
                patientView: {
                    description: string;
                    properties: {
                        showLocationBookings: {
                            description: string;
                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                            defaultValue: boolean;
                        };
                        showOutpatientAppointments: {
                            description: string;
                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                            defaultValue: boolean;
                        };
                    };
                };
            };
        };
        templates: {
            description: string;
            properties: {
                appointmentConfirmation: {
                    description: string;
                    properties: {
                        subject: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        body: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
                letterhead: {
                    description: string;
                    properties: {
                        title: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        subTitle: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
                signerRenewalEmail: {
                    description: string;
                    properties: {
                        subject: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        body: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
                vaccineCertificateEmail: {
                    description: string;
                    properties: {
                        subject: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        body: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
                covidVaccineCertificateEmail: {
                    description: string;
                    properties: {
                        subject: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        body: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
                covidTestCertificateEmail: {
                    description: string;
                    properties: {
                        subject: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        body: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
                covidClearanceCertificateEmail: {
                    description: string;
                    properties: {
                        subject: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        body: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
                vaccineCertificate: {
                    description: string;
                    properties: {
                        emailAddress: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        contactNumber: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        healthFacility: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
                covidTestCertificate: {
                    description: string;
                    properties: {
                        laboratoryName: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        clearanceCertRemark: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
                plannedMoveTimeoutHours: {
                    description: string;
                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                    defaultValue: number;
                    unit: string;
                };
            };
        };
        triageCategories: {
            name: string;
            description: string;
            type: yup.ArraySchema<{
                label?: string;
                level?: number;
                color?: string;
            }[], yup.AnyObject, undefined, "">;
            defaultValue: {
                level: number;
                label: string;
                color: string;
            }[];
        };
        upcomingVaccinations: {
            name: string;
            description: string;
            properties: {
                ageLimit: {
                    description: string;
                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                    defaultValue: number;
                };
                thresholds: {
                    description: string;
                    type: yup.ArraySchema<{
                        threshold?: {};
                        status?: string;
                    }[], yup.AnyObject, undefined, "">;
                    defaultValue: ({
                        threshold: number;
                        status: string;
                    } | {
                        threshold: string;
                        status: string;
                    })[];
                };
            };
        };
        vitalEditReasons: {
            description: string;
            type: yup.ArraySchema<{
                label?: string;
                value?: string;
            }[], yup.AnyObject, undefined, "">;
            defaultValue: {
                value: string;
                label: string;
            }[];
        };
        notifications: {
            description: string;
            properties: {
                recentNotificationsTimeFrame: {
                    description: string;
                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                    defaultValue: number;
                };
            };
        };
    };
};
export declare const globalDefaults: any;
