"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "EncounterMedication", {
    enumerable: true,
    get: function() {
        return EncounterMedication;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _dateTime = require("@tamanu/utils/dateTime");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
const _model = require("../types/model");
let EncounterMedication = class EncounterMedication extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            date: (0, _model.dateTimeType)('date', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateTimeString
            }),
            endDate: (0, _model.dateTimeType)('endDate'),
            prescription: _sequelize.DataTypes.STRING,
            note: _sequelize.DataTypes.STRING,
            indication: _sequelize.DataTypes.STRING,
            route: _sequelize.DataTypes.STRING,
            qtyMorning: _sequelize.DataTypes.INTEGER,
            qtyLunch: _sequelize.DataTypes.INTEGER,
            qtyEvening: _sequelize.DataTypes.INTEGER,
            qtyNight: _sequelize.DataTypes.INTEGER,
            quantity: _sequelize.DataTypes.INTEGER,
            discontinued: _sequelize.DataTypes.BOOLEAN,
            discontinuedDate: _sequelize.DataTypes.STRING,
            discontinuingReason: _sequelize.DataTypes.STRING,
            repeats: _sequelize.DataTypes.INTEGER,
            isDischarge: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false,
                defaultValue: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            validate: {
                mustHaveMedication () {
                    if (!this.medicationId) {
                        throw new Error('An encounter medication must be attached to a medication.');
                    }
                },
                mustHaveEncounter () {
                    if (!this.encounterId) {
                        throw new Error('An encounter medication must be attached to an encounter.');
                    }
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'prescriberId',
            as: 'prescriber'
        });
        this.belongsTo(models.User, {
            foreignKey: 'discontinuingClinicianId',
            as: 'discontinuingClinician'
        });
        this.belongsTo(models.Encounter, {
            foreignKey: 'encounterId',
            as: 'encounter'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'medicationId',
            as: 'Medication'
        });
    }
    static getListReferenceAssociations() {
        return [
            'Medication',
            'encounter',
            'prescriber',
            'discontinuingClinician'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupFilter)(this);
    }
};

//# sourceMappingURL=EncounterMedication.js.map