import { OTLPMetricExporter as GrpcMetricExporter } from '@opentelemetry/exporter-metrics-otlp-grpc';
import { OTLPMetricExporter as HttpProtoMetricExporter } from '@opentelemetry/exporter-metrics-otlp-proto';
import { PeriodicExportingMetricReader } from '@opentelemetry/sdk-metrics';
import { SpanExporter } from '@opentelemetry/sdk-trace-base';
import { HoneycombOptions } from './honeycomb-options';
export declare const TEAM_HEADER_KEY = "x-honeycomb-team";
export declare const DATASET_HEADER_KEY = "x-honeycomb-dataset";
export declare const OTLP_HEADER_KEY = "x-otlp-version";
export declare const OTLP_PROTO_VERSION = "0.16.0";
/**
 * Configures and returns a {@link SpanExporter} based on the OTLP protocol
 * provided via options.
 *
 * Defaults to a http/protobuf exporter if not configured.
 *
 * @param options the {@link HoneycombOptions} used to configure the exporter
 * @returns a {@link SpanExporter} configured to send telemetry to Honeycomb
 */
export declare function getHoneycombSpanExporter(options?: HoneycombOptions): SpanExporter;
/**
 * Configures and returns a metric exporter based on the OTLP protocol
 * provided via options.
 *
 * Defaults to a http/protobuf exporter if not configured.
 *
 * @param options the {@link HoneycombOptions} used to configure the exporter
 * @returns a metrics exporter configured to send telemetry to Honeycomb
 */
export declare function getHoneycombMetricExporter(options?: HoneycombOptions): GrpcMetricExporter | HttpProtoMetricExporter;
/**
 * Builds and returns an OTLP Metric reader that configures a metric exporter to send data over http/protobuf periodically
 * @param options The {@link HoneycombOptions} used to configure the exporter
 * @returns a {@link PeriodicExportingMetricReader} configured to send telemetry to Honeycomb over http/protobuf
 */
export declare function getHoneycombMetricReader(options?: HoneycombOptions): PeriodicExportingMetricReader | undefined;
