"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    DEFAULT_JWT_REFRESH_SECRET: function() {
        return DEFAULT_JWT_REFRESH_SECRET;
    },
    DEFAULT_JWT_SECRET: function() {
        return DEFAULT_JWT_SECRET;
    },
    authModule: function() {
        return authModule;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _crypto = /*#__PURE__*/ _interop_require_default(require("crypto"));
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _middleware = require("@tamanu/shared/permissions/middleware");
const _convertDbRecord = require("../convertDbRecord");
const _changePassword = require("./changePassword");
const _resetPassword = require("./resetPassword");
const _login = require("./login");
const _refresh = require("./refresh");
const _userMiddleware = require("./userMiddleware");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const DEFAULT_JWT_SECRET = _config.default.auth.secret || _crypto.default.randomUUID();
const DEFAULT_JWT_REFRESH_SECRET = _config.default.auth.refreshToken.secret || _crypto.default.randomUUID();
const authModule = _express.default.Router();
authModule.use('/resetPassword', _resetPassword.resetPassword);
authModule.use('/changePassword', _changePassword.changePassword);
authModule.post('/login', (0, _login.login)({
    secret: DEFAULT_JWT_SECRET,
    refreshSecret: DEFAULT_JWT_REFRESH_SECRET
}));
authModule.post('/refresh', (0, _refresh.refresh)({
    secret: DEFAULT_JWT_SECRET,
    refreshSecret: DEFAULT_JWT_REFRESH_SECRET
}));
authModule.use((0, _userMiddleware.userMiddleware)({
    secret: DEFAULT_JWT_SECRET
}));
authModule.get('/user/me', _userMiddleware.userInfo);
authModule.get('/permissions', (0, _expressasynchandler.default)(_middleware.getPermissions));
authModule.get('/whoami', (0, _expressasynchandler.default)((req, res)=>{
    res.send((0, _convertDbRecord.convertFromDbRecord)(req.user).data);
}));

//# sourceMappingURL=index.js.map