"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "countSyncSnapshotRecords", {
    enumerable: true,
    get: function() {
        return countSyncSnapshotRecords;
    }
});
const _sequelize = require("sequelize");
const _manageSnapshotTable = require("./manageSnapshotTable");
const countSyncSnapshotRecords = async (sequelize, sessionId, direction, recordType)=>{
    const tableName = (0, _manageSnapshotTable.getSnapshotTableName)(sessionId);
    const rows = await sequelize.query(`
      SELECT count(*) AS total FROM ${tableName}
      WHERE direction = :direction
      ${recordType ? 'AND record_type = :recordType' : ''};
    `, {
        replacements: {
            recordType,
            direction
        },
        type: _sequelize.QueryTypes.SELECT,
        raw: true
    });
    return rows[0]?.total || 0;
};

//# sourceMappingURL=countSyncSnapshotRecords.js.map