"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getEnumPrefix: function() {
        return getEnumPrefix;
    },
    isRegisteredEnum: function() {
        return isRegisteredEnum;
    },
    throwIfNotRegisteredEnum: function() {
        return throwIfNotRegisteredEnum;
    }
});
const _constants = require("@tamanu/constants");
const isRegisteredEnum = (enumValues)=>_constants.enumRegistry.has(enumValues);
const getEnumPrefix = (enumValues)=>_constants.prefixMap.get(enumValues);
const throwIfNotRegisteredEnum = (enumValues, fieldName)=>{
    if (!isRegisteredEnum(enumValues)) {
        throw new Error(`enumValues for ${fieldName ? `for field ${fieldName} ` : ''}are not registered in enumRegistry: ${JSON.stringify(enumValues)} `);
    }
    if (!getEnumPrefix(enumValues)) {
        throw new Error(`enumValues for ${fieldName ? `for field ${fieldName} ` : ''}has no associated prefix: ${JSON.stringify(enumValues)}`);
    }
};

//# sourceMappingURL=enumRegistry.js.map