"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveCommunityCLI = resolveCommunityCLI;
exports.loadContext = loadContext;
const package_1 = require("@rnx-kit/tools-node/package");
const cache_1 = require("./cache");
// As of 0.76, `@react-native-community/cli` is no longer a dependency of
// `react-native`. Consumers have to take a direct dependency on CLI instead.
const RN_CLI_DECOUPLED = 76;
function toNumber(version) {
    const [major, minor = 0] = version.split(".");
    return Number(major) * 1000 + Number(minor);
}
function findStartDir(root, reactNativePath = "") {
    const reactNative = reactNativePath ||
        (0, package_1.findPackageDependencyDir)("react-native", {
            startDir: root,
            resolveSymlinks: true,
        });
    if (!reactNative) {
        return root;
    }
    const { version } = (0, package_1.readPackage)(reactNative);
    return toNumber(version) < RN_CLI_DECOUPLED ? reactNative : root;
}
/**
 * Finds path to `@react-native-community/cli`.
 * @param root Project root
 * @param reactNativePath Path to `react-native`, if known
 */
function resolveCommunityCLI(root, reactNativePath = "") {
    const startDir = findStartDir(root, reactNativePath);
    return require.resolve("@react-native-community/cli", { paths: [startDir] });
}
/**
 * Equivalent to calling `loadConfig()` from `@react-native-community/cli`, but
 * the result is cached for faster subsequent accesses.
 * @param root Project root; defaults to current working directory
 */
function loadContext(root = process.cwd()) {
    const state = (0, cache_1.getCurrentState)(root);
    if (state === (0, cache_1.getSavedState)(root)) {
        const config = (0, cache_1.loadConfigFromCache)(root);
        if (config) {
            return config;
        }
    }
    const rncli = resolveCommunityCLI(root);
    const { loadConfig } = require(rncli);
    const config = loadConfig.length === 1
        ? loadConfig({ projectRoot: root })
        : loadConfig(root);
    (0, cache_1.saveConfigToCache)(root, state, config);
    return config;
}
//# sourceMappingURL=context.js.map