"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.addIndex('sync_lookup', {
        fields: [
            'updated_at_sync_tick',
            'record_id',
            'patient_id',
            'facility_id'
        ]
    });
}
async function down(query) {
    await query.removeIndex('sync_lookup', 'sync_lookup_updated_at_sync_tick_record_id_patient_id_facility_id');
}

//# sourceMappingURL=1721609043697-addIndexesToSyncLookupTable.js.map