/**
 * Create custom datetime Sequelize types and link to Postgres types.
 */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createDateTypes", {
    enumerable: true,
    get: function() {
        return createDateTypes;
    }
});
const _util = /*#__PURE__*/ _interop_require_default(require("util"));
const _sequelize = require("sequelize");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
// Necessary as DataTypes.ABSTRACT is wrapped with classToInvokable()
const ABSTRACT = _sequelize.DataTypes.ABSTRACT.prototype.constructor;
function createDateTypes() {
    let DATETIMESTRING = class DATETIMESTRING extends ABSTRACT {
        toSql() {
            return 'date_time_string';
        }
        validate(value) {
            return typeof value === 'string' && value.length === 19;
        }
    };
    let DATESTRING = class DATESTRING extends ABSTRACT {
        toSql() {
            return 'date_string';
        }
        validate(value) {
            return typeof value === 'string' && value.length === 10;
        }
    };
    // TIMESTAMP WITHOUT TIME ZONE
    const TIMESTAMP = function TIMESTAMP() {};
    _util.default.inherits(TIMESTAMP, _sequelize.DataTypes.DATE);
    TIMESTAMP.prototype.toSql = ()=>'TIMESTAMP';
    // Set the type key
    DATETIMESTRING.prototype.key = 'date_time_string';
    DATESTRING.prototype.key = 'date_string';
    TIMESTAMP.prototype.key = 'TIMESTAMP';
    // Make datatype able to be used directly without having to call `new` on it.
    _sequelize.DataTypes.DATETIMESTRING = _sequelize.Utils.classToInvokable(DATETIMESTRING);
    _sequelize.DataTypes.DATESTRING = _sequelize.Utils.classToInvokable(DATESTRING);
    _sequelize.DataTypes.TIMESTAMP = _sequelize.Utils.classToInvokable(TIMESTAMP);
    // Map the datatype to the postgres type/domain name
    _sequelize.DataTypes.DATETIMESTRING.types.postgres = [
        'date_time_string'
    ];
    _sequelize.DataTypes.DATESTRING.types.postgres = [
        'date_string'
    ];
    const PgTypes = _sequelize.DataTypes.postgres;
    PgTypes.DATETIMESTRING = function dateTimeString(...args) {
        if (!(this instanceof PgTypes.DATETIMESTRING)) return new PgTypes.DATETIMESTRING();
        return _sequelize.DataTypes.DATETIMESTRING.apply(this, args);
    };
    PgTypes.DATESTRING = function dateString(...args) {
        if (!(this instanceof PgTypes.DATESTRING)) return new PgTypes.DATESTRING();
        return _sequelize.DataTypes.DATESTRING.apply(this, args);
    };
    _util.default.inherits(PgTypes.DATETIMESTRING, _sequelize.DataTypes.DATETIMESTRING);
    _util.default.inherits(PgTypes.DATESTRING, _sequelize.DataTypes.DATESTRING);
    // Reassign postgres-specific parser
    PgTypes.DATETIMESTRING.parse = _sequelize.DataTypes.DATETIMESTRING.parse;
    PgTypes.DATESTRING.parse = _sequelize.DataTypes.DATESTRING.parse;
    // These two extra steps are seemingly necessary altho not described in sequelize docs
    PgTypes.DATETIMESTRING.types = {
        postgres: [
            'date_time_string'
        ]
    };
    _sequelize.DataTypes.postgres.DATETIMESTRING.key = 'date_time_string';
    PgTypes.DATESTRING.types = {
        postgres: [
            'date_string'
        ]
    };
    _sequelize.DataTypes.postgres.DATESTRING.key = 'date_string';
}

//# sourceMappingURL=createDateTypes.js.map