"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createAppointment: function() {
        return createAppointment;
    },
    createRepeatingAppointment: function() {
        return createRepeatingAppointment;
    }
});
const _lodash = require("lodash");
const _constants = require("@tamanu/constants");
const _utilities = require("@tamanu/database/demoData/utilities");
const _fake = require("../../fake");
const createAppointment = async ({ models, locationGroupId, patientId, clinicianId })=>{
    const { Appointment } = models;
    await Appointment.create((0, _fake.fake)(Appointment, {
        patientId: patientId || await (0, _utilities.randomRecordId)(models, 'Patient'),
        clinicianId: clinicianId || await (0, _utilities.randomRecordId)(models, 'User'),
        locationGroupId: locationGroupId || await (0, _utilities.randomRecordId)(models, 'LocationGroup')
    }));
};
const createRepeatingAppointment = async ({ models, locationGroupId, patientId, clinicianId, apptCount = _fake.chance.integer({
    min: 1,
    max: 50
}) })=>{
    const { AppointmentSchedule, Appointment } = models;
    const appointmentSchedule = await AppointmentSchedule.create((0, _fake.fake)(AppointmentSchedule, {
        frequency: _constants.REPEAT_FREQUENCY.WEEKLY,
        locationGroupId: locationGroupId || await (0, _utilities.randomRecordId)(models, 'LocationGroup')
    }));
    (0, _lodash.times)(apptCount, async ()=>{
        await Appointment.create((0, _fake.fake)(Appointment, {
            patientId: patientId || await (0, _utilities.randomRecordId)(models, 'Patient'),
            clinicianId: clinicianId || await (0, _utilities.randomRecordId)(models, 'User'),
            locationGroupId: locationGroupId || await (0, _utilities.randomRecordId)(models, 'LocationGroup'),
            scheduleId: appointmentSchedule.id
        }));
    });
};

//# sourceMappingURL=appointment.js.map