import { times } from 'lodash';
import { fake, chance } from '../../fake';
export const createLabRequest = async ({ models, departmentId, userId, encounterId, referenceDataId, patientId, labTestTypeId, testCount = chance.integer({
    min: 1,
    max: 10
}) })=>{
    const { LabRequest, LabRequestLog, LabTest, CertificateNotification } = models;
    const labRequest = await LabRequest.create(fake(LabRequest, {
        departmentId,
        collectedById: userId,
        encounter: encounterId
    }));
    await LabRequestLog.create(fake(LabRequestLog, {
        status: 'reception_pending',
        labRequestId: labRequest.id
    }));
    times(testCount, async ()=>{
        const labTest = await LabTest.create(fake(LabTest, {
            labRequestId: labRequest.id,
            categoryId: referenceDataId,
            labTestMethodId: referenceDataId,
            labTestTypeId
        }));
        await CertificateNotification.create(fake(CertificateNotification, {
            patientId,
            labTestId: labTest.id,
            labRequestId: labRequest.id
        }));
    });
};

//# sourceMappingURL=labRequest.js.map