"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "fhirJobStats", {
    enumerable: true,
    get: function() {
        return fhirJobStats;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const fhirJobStats = (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const { store, query } = req;
    const { order: orderUnsafe, orderBy: orderByUnsafe } = query;
    const order = orderUnsafe === 'desc' ? 'desc' : 'asc';
    const orderBy = {
        topic: 'topic',
        status: 'status',
        count: 'COUNT(*)'
    }[orderByUnsafe] || 'topic';
    const stats = await store.sequelize.query(`SELECT topic, status, count(*)
     FROM fhir.jobs
     GROUP BY topic, status
     ORDER BY ${orderBy} ${order};`, {
        type: _sequelize.QueryTypes.SELECT
    });
    res.send({
        data: stats.map(({ topic, status, count })=>({
                id: `${topic},${status}`,
                topic,
                status,
                count
            })),
        count: stats.length
    });
});

//# sourceMappingURL=fhirJobStats.js.map