"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createLabRequest", {
    enumerable: true,
    get: function() {
        return createLabRequest;
    }
});
const _lodash = require("lodash");
const _fake = require("../../fake");
const createLabRequest = async ({ models, departmentId, userId, encounterId, referenceDataId, patientId, labTestTypeId, testCount = _fake.chance.integer({
    min: 1,
    max: 10
}) })=>{
    const { LabRequest, LabRequestLog, LabTest, CertificateNotification } = models;
    const labRequest = await LabRequest.create((0, _fake.fake)(LabRequest, {
        departmentId,
        collectedById: userId,
        encounter: encounterId
    }));
    await LabRequestLog.create((0, _fake.fake)(LabRequestLog, {
        status: 'reception_pending',
        labRequestId: labRequest.id
    }));
    (0, _lodash.times)(testCount, async ()=>{
        const labTest = await LabTest.create((0, _fake.fake)(LabTest, {
            labRequestId: labRequest.id,
            categoryId: referenceDataId,
            labTestMethodId: referenceDataId,
            labTestTypeId
        }));
        await CertificateNotification.create((0, _fake.fake)(CertificateNotification, {
            patientId,
            labTestId: labTest.id,
            labRequestId: labRequest.id
        }));
    });
};

//# sourceMappingURL=labRequest.js.map