/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('patient_additional_data', 'insurer_id', {
        type: _sequelize.DataTypes.STRING,
        references: {
            model: 'reference_data',
            key: 'id'
        },
        allowNull: true
    });
    await query.addColumn('patient_additional_data', 'insurer_policy_number', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
}
async function down(query) {
    await query.removeColumn('patient_additional_data', 'insurer_id');
    await query.removeColumn('patient_additional_data', 'insurer_policy_number');
}

//# sourceMappingURL=1714984691719-addInsurerIdAndPolicyToPatientAdditionalData.js.map